#include <iostream>
#include <algorithm>
#include <vector>
#include <math.h>
#include <set>
using namespace std;
#define ll long long
const double sqrt2 = sqrt(2);

struct point
{
	int x, y;
	pair<int, int> to_pair()
	{
		return pair<int, int>(x, y);
	}
};
struct segment
{
	point p1, p2;
};
/// <summary> Returns the double area within the given polygon </summary> 
ll compute_area(vector<point>* points)
{
	ll area = 0;
	for (int i = 0; i < points->size(); i++)
		area += points->at(i).x * points->at((i + 1) % points->size()).y;
	
	for (int i = 0; i < points->size(); i++)
		area -= points->at(i).y * points->at((i + 1) % points->size()).x;

	return abs(area);
}

int get_orientation(point* p0, point* p1, point* p2)
{
	ll area = (p0->x * p1->y + p1->x * p2->y + p2->x * p0->y) - (p0->y * p1->x + p1->y * p2->x + p2->y * p0->x);
	if (area > 0)
		return 1;
	else if (area < 0)
		return -1;
	else
		return 0;
}

bool do_ranges_intersect(pair<int, int> range1, pair<int, int> range2)
{
	if ((range2.first > range1.first && range2.first < range1.second) ||
		(range2.second > range1.first && range2.second < range1.second))
	{
		return true;
	}
	if ((range1.first > range2.first && range1.first < range2.second) ||
		(range1.second > range2.first && range1.second < range2.second))
	{
		return true;
	}
	return false;
}

bool do_segments_intersect(vector<segment>* segments)
{
	for (int i = 0; i < segments->size(); i++)
	{
		for (int j = 0; j < segments->size(); j++)
		{
			if (i == j)
				continue;
			segment segment1 = segments->at(i);
			segment segment2 = segments->at(j);
			set<pair<int,int>> unique_points = {segment1.p1.to_pair(),segment1.p2.to_pair(),
				segment2.p1.to_pair(),segment2.p2.to_pair() };
			
			if (unique_points.size() == 2) // Segments are colinear
			{
				return true;
			}
			if (unique_points.size() == 3)
			{
				pair<int, int> x_range_seg1 = { min(segment1.p1.x,segment1.p2.x),max(segment1.p1.x,segment1.p2.x) };
				pair<int, int> y_range_seg1 = { min(segment1.p1.y,segment1.p2.y),max(segment1.p1.y,segment1.p2.y) };
				pair<int,int> x_range_seg2 = { min(segment2.p1.x,segment2.p2.x),max(segment2.p1.x,segment2.p2.x) };
				pair<int, int> y_range_seg2 = { min(segment2.p1.y,segment2.p2.y),max(segment2.p1.y,segment2.p2.y) };
				if (y_range_seg1.first == y_range_seg1.second && y_range_seg2.first == y_range_seg2.second)
				{
					if (do_ranges_intersect(x_range_seg1, x_range_seg2))
					{
						return true;
					}
				}
				else if(x_range_seg1.first == x_range_seg1.second && x_range_seg2.first == x_range_seg2.second)
				{
					if (do_ranges_intersect(y_range_seg1,y_range_seg2))
					{
						return true;
					}
				}
				else
					continue;
			}
			pair<int,int> x_range_seg1 = { min(segment1.p1.x,segment1.p2.x),max(segment1.p1.x,segment1.p2.x) };
			pair<int,int> y_range_seg1 = { min(segment1.p1.y,segment1.p2.y),max(segment1.p1.y,segment1.p2.y) };
			if ((segment2.p1.x >= x_range_seg1.first && segment2.p1.x <= x_range_seg1.second) ||
				(segment2.p2.x >= x_range_seg1.first && segment2.p2.x <= x_range_seg1.second) ||
				(segment2.p1.y >= y_range_seg1.first && segment2.p1.y <= y_range_seg1.second) ||
				(segment2.p2.y >= y_range_seg1.first && segment2.p2.y <= y_range_seg1.second))
			{
				// Segments might intersect
				int orientation1 = get_orientation(&segment1.p1, &segment1.p2, &segment2.p1);
				int orientation2 = get_orientation(&segment1.p1, &segment1.p2, &segment2.p2);
				if (orientation1 != 0 && orientation2 != 0 && orientation1 != orientation2)
				{
					return true;
				}
			}
		}
	}
	return false;
}
bool does_polygon_intersect(vector<point>* points)
{
	vector<segment> segments; segments.reserve(points->size());
	for (int i = 0; i < points->size(); i++)
	{
		point a = points->at(i);
		point b = points->at((i + 1) % points->size());
		segments.push_back({ a,b });
	}
	return do_segments_intersect(&segments);
}
ll max_area = -1;
vector<point> current_points;
vector<point> deltas = { {-1,0},{1,0},{0,-1},{0,1},{-1,-1},{-1,1},{1,-1},{1,1} };
vector<double> costs = { 1,1,1,1,sqrt2,sqrt2,sqrt2,sqrt2 };
/// <summary> Find max area given the remaining length starting from current_position </summary>
ll find_max_area(int end_x, double remaining_length, point current_position)
{
	if (current_position.y < 0 || remaining_length < 0) // Illegal move
		return -1;
	current_points.push_back(current_position);
	if (current_position.y == 0 && current_position.x == end_x) // End has been reached
	{
		if (does_polygon_intersect(&current_points)) // Illegal path
		{
			current_points.pop_back();
			return -1;
		}
		ll area = compute_area(&current_points);
		current_points.pop_back();
		return area;
	}
	for (int i = 0; i < deltas.size(); i++)
	{
		point delta = deltas[i];
		point new_position = { current_position.x + delta.x,current_position.y + delta.y };
		max_area = max(max_area, find_max_area(end_x, remaining_length - costs[i], new_position));
	}
	current_points.pop_back();
	return max_area;
}


int Dido(int W, int L)
{
	ll max_area = find_max_area(W, L, { 0,0 });
	if (max_area == -1)
	{
		return 0;
	}
	return max_area;
}