#include <iostream>
#include <algorithm>
#include <vector>
using namespace std;
#define ll long long
const double sqrt2 = sqrt(2);
struct point
{
	int x, y;
};
/// <summary> Returns the double area within the given polygon </summary> 
ll compute_area(vector<point>* points)
{
	ll area = 0;
	for (int i = 0; i < points->size(); i++)
		area += points->at(i).x * points->at((i + 1) % points->size()).y;
	
	for (int i = 0; i < points->size(); i++)
		area -= points->at(i).y * points->at((i + 1) % points->size()).x;

	return abs(area);
}
ll max_area = -1;
vector<point> current_points;
vector<point> deltas = { {-1,0},{1,0},{0,-1},{0,1},{-1,-1},{-1,1},{1,-1},{1,1} };
vector<double> costs = { 1,1,1,1,sqrt2,sqrt2,sqrt2,sqrt2 };
/// <summary> Find max area given the remaining length starting from current_position </summary>
ll find_max_area(int end_x, int remaining_length, point current_position)
{
	if (current_position.y < 0 || remaining_length < 0) // Illegal move
		return -1;
	current_points.push_back(current_position);
	if (current_position.y == 0 && current_position.x == end_x) // End has been reached
	{
		current_points.pop_back();
		return compute_area(&current_points);
	}
	for (int i = 0; i < deltas.size(); i++)
	{
		point delta = deltas[i];
		point new_position = { current_position.x + delta.x,current_position.y + delta.y };
		max_area = max(max_area, find_max_area(end_x, remaining_length - costs[i], new_position));
	}
	current_points.pop_back();
	return max_area;
}


int Dido(int W, int L)
{
	return find_max_area(W, L, {0,0});
}