#include <bits/stdc++.h>

using ull = unsigned long long;
using uint = unsigned int;

constexpr uint T = 5;
constexpr uint N = 75'000;
constexpr uint M = 75'000;

auto find_x(ull arr[], uint size) -> ull {
	static auto swap = [](auto& a, auto& b) {
		const auto p = a;
		a = b;
		b = p;
	};

	ull result = arr[1] - *arr;

	for (uint i = 1; i < size - 1; ++i) {
		auto diff = arr[i + 1] - arr[i];
		if (diff < result)
			swap(diff, result);

		if (diff == result)
			continue;

		if (diff % result)
			return 0;
	}
	return result;
}

auto main() -> int {
	uint t;
	std::scanf("%u", &t);

	uint n, m;
	ull a[N], b[M];

	for (uint i = 0; i < t; ++i) {
		std::scanf("%u%u", &n, &m);

		for (uint j = 0; j < n; ++j)
			std::scanf("%u", a + j);

		for (uint j = 0; j < m; ++j)
			std::scanf("%u", b + j);

		std::sort(std::begin(a), std::begin(a) + n);

		const auto x = find_x(a, n);

		if (!x) {
			std::printf("0\n");
			continue;
		}

		const auto mid_a = a[n / 2];

		for (uint j = 0; j < m; ++j)
			if (std::abs((long long)b[j] - (long long)mid_a) % x == 0)
				goto error;

		std::printf("1\n");

		continue;
	error:
		std::printf("0\n");
	}
}