#include <stdio.h>

void razmeni(long long *x, long long *y) {
    int t = *x;
    *x = *y;
    *y = t;
}

int podeli(long long a[], int l, int d) {
    int k = l;
    int i;

    for (i = l + 1; i <= d; i++) {
        if (a[i] < a[l]) {
            k++;
            razmeni(&a[i], &a[k]);
        }
    }

    razmeni(&a[l], &a[k]);

    return k;
}

void quickSort(long long a[], int l, int d) {
    if (l < d) {
        int k = podeli(a, l, d);
        quickSort(a, 1, k - 1);
        quickSort(a, k + 1, d);
    }
}

int main() {
    int t;
    scanf("%d", &t);

    for (int i = 0; i < t; i++) {
        int n, m;
        scanf("%d %d", &n, &m);

        long long a[n], b[m];

        for (int j = 0; j < n; j++) {
            scanf("%lld", &a[j]);
        }

        for (int j = 0; j < m; j++) {
            scanf("%lld", &b[j]);
        }

        quickSort(a, 0, n - 1);
        quickSort(b, 0, m - 1);

        long long x = a[1] - a[0];

        for (int j = 1; j < n - 1; j++) {
            long long r = a[i + 1] - a[i];
            if (r < x) {
                x = r;
            }
        }

        int j = 0;
        int k = 0;

        long long y = a[0] - x;

        int bool = 1;

        while (bool && j < n) {
            y += x;

            while (k < m && y < b[k]) {
                k++;
            }

            if (y == b[k] || y > a[j]) {
                bool = 0;
            }

            else if (y == a[j]) {
                j++;
            }
        }

        if (bool) {
            bool = j == n;
        }

        printf("%d\n", bool);
    }

    return 0;
}