#include <bits/stdc++.h>
using namespace std;

#define long int64_t
#define endl '\n'

#ifdef OFFLINE
	#define logan(...) logg(#__VA_ARGS__, __VA_ARGS__)
	template<class Arg>
	void logg(const char* name, Arg&& arg){ cerr << name << ": " << arg << '\n'; }
	template<class Arg, class ... Args>
	void logg(const char* name, Arg&& arg, Args&& ... args){
		char *next = (char*)name, *cand;
		int depth = 0;
		do{
			if(depth){ next = strchr(next+1, ')'); --depth; }
			else if((cand = strchr(next+1, '('))){ next = cand; ++depth; }
			else{ next = strchr(next+1, ','); }
		}while(depth);
		cerr.write(name, next-name) << ": " << arg << ",";
		logg(next+1, args...);
	}
	#define timeme 1.0*clock()/CLOCKS_PER_SEC
#else
	#define logan(...) {}
	#define timeme {}
#endif

long a[75'001];
long b[75'001];

template<class T>
T gcd(T a, T b) {
	T t;
	while (a) { t = a; a = b % a; b = t; }
	return b;
}

int main(){
	ios_base::sync_with_stdio(false);
	cin.tie(nullptr);
	cout.tie(nullptr);
	cerr.tie(nullptr);
	
	int t; cin >> t;
	for(;t--;){
		int n, m; cin >> n >> m;
		for(int i = 0; i < n; ++i)
			cin >> a[i];
		for(int i = 0; i < m; ++i)
			cin >> b[i];

		sort(a, a+n);
		sort(b, b+m);


		long da = a[1]-a[0];
		for(int i = 2; i < n; ++i)
			da = gcd(da, a[i]-a[i-1]);

		int ok = 1;
		long start = a[0];
		for(int i = 0; ok && i < m; ++i){
			if(b[i] > start)
				ok = (b[i]-start)%da;
			else
				ok = (start-b[i])%da;
		}

		cout << !!ok << endl;
	}

}