#include <iostream>
#include <unordered_set>
#include <vector>
#include <cmath>

using namespace std;

long long Euclid(long long a, long long b)
{
	if(b == 0) return a;
	return Euclid(b, a%b);
}

void PrimeDivisors(unordered_set<long long>& factors, long long n)
{
	if(n%2 == 0) 
	{
		factors.insert(2);
		n/=2;
	}
	int sq = sqrt(n);
	for(int i = 3; i <= sq; i+=2)
	{
		if(n % i == 0) factors.insert(i);
		while(n % i == 0) n/=i;
	}
	
	if(n > 2) factors.insert(n);
}

int main()
{
	ios_base::sync_with_stdio(false);
	cin.tie(0);
	
	int t;
	cin >> t;
	vector<int> sol;
	
	while(t > 0)
	{
		--t;
		int n, m;
		cin >> n >> m;
		
		long long a[n];
		long long b[m];
		
		for(int i = 0; i < n; ++i)
			cin >> a[i];
		
		for(int i = 0; i < m; ++i)
			cin >> b[i];
			
		long long min_el = a[0];
		for(int i = 1; i < n; ++i)
			if(a[i] < min_el) min_el = a[i];
		
		n--;
		long long nzd = abs(a[0]-a[1]);
		for(int i = 1; i < n; ++i)
		{
			nzd = Euclid(nzd, abs(a[i]-a[i+1]));
		}
		n++;
		
		if(nzd == 1) 
		{
			sol.push_back(0);
			continue;
		}
		
		unordered_set<long long> min_factors;
		PrimeDivisors(min_factors, nzd);
		
		for(int i = 0; i < m; ++i)
			b[i] = abs(b[i]-min_el);
			
		unordered_set<long long> factors;
		--m;
		for(int i = 0; i < m; ++i)
			PrimeDivisors(factors, abs(b[i]-b[i+1]));
			
		++m;
		
		bool succ = false;
		for(unordered_set<long long>::iterator it = min_factors.begin(); it!=min_factors.end(); ++it)
		{
			if(factors.find(*it) == factors.end())
			{
				sol.push_back(1);
				succ = true;
				break;
			}
		}
		if (succ) continue;
		sol.push_back(0);
	}
	
	for(int i = 0; i < sol.size(); ++i)
		cout << sol[i] << endl;
}