#include <iostream>
#include <unordered_set>
#include <vector>
#include <cmath>

using namespace std;

long long Euclid(long long a, long long b)
{
	if(b == 0) return a;
	return Euclid(b, a%b);
}

void Factorization(vector<long long>& factors, long long n)
{
	if(n % 2 == 0)
	{
		factors.push_back(2);
		while(n%2==0) n/=2;
	}
	
	long long sqr = sqrt(n);
	for(int i = 3; i <= sqr; ++i)
	{
		if(n%i == 0)
		{
			factors.push_back(i);
			while(n%i == 0) n/=i;
		}
	}
	
	if(n > 2) factors.push_back(n);
}


int main()
{
	ios_base::sync_with_stdio(false);
	cin.tie(0);
	
	int t;
	cin >> t;
	vector<int> sol;
	
	while(t > 0)
	{
		--t;
		int n, m;
		cin >> n >> m;
		
		long long a[n];
		long long b[m];
		
		for(int i = 0; i < n; ++i)
			cin >> a[i];
		
		for(int i = 0; i < m; ++i)
			cin >> b[i];
			
		int min_el = a[0];
		for(int i = 1; i < n; ++i)
			if(a[i] < min_el) min_el = a[i];
			
		for(int i = 0; i < n; ++i)
			a[i]-=min_el;
			
			
		for(int i = 0; i < m; ++i)
			b[i] = abs(b[i]-min_el);
			
		long long nzd = 0;
		for(int i = 0; i < n; ++i)
		{
			nzd = Euclid(nzd, a[i]);
		}
		if(nzd == 1)
		{
			sol.push_back(0);
			continue;
		}
		
		vector<long long> factors;
		Factorization(factors, nzd);
		
		
		bool check = false;
		for(int i = 0; i < factors.size(); ++i)
		{
			bool tempCheck = true;
			for(int j = 0; j < m; ++j)
				if(b[j] % factors[i] == 0)
				{
					tempCheck = false;
					break;
				}
			check = tempCheck;
		}
		
		if(check) sol.push_back(1);
		else sol.push_back(0);
	}
	
	for(int i = 0; i < sol.size(); ++i)
		cout << sol[i] << endl;
}