using System;

namespace ConsoleApp10
{
    class Program
    {
        public struct poznanici
        {
            public int prvi;
            public int drugi;
        }
        static void Main(string[] args)
        {
            const int N = 100000;
            const long druzmax = 1000000000;

            long[] ucenici = new long[N];
            int[] prijatelji = new int[N];
            int[] neprijatelji = new int[N];

            poznanici[] parovi = new poznanici[N];

            //ucitavaju se n i m
            string[] r = Console.ReadLine().Split();
            int n = int.Parse(r[0]);
            if (n < 1 || n > N)
                Console.WriteLine("Vrednost n nije uneta dobro");
            int m = int.Parse(r[1]);
            if (m < 1 || m > N)
                Console.WriteLine("Vrednost m nije uneta dobro");

            //ucitava se druzeljubivost ucenika i prijatelji i neprijatelji se postavljaju na 0

            for (int i = 0; i < n; i++)
            {
                ucenici[i] = long.Parse(Console.ReadLine());
                prijatelji[i] = 0;
                neprijatelji[i] = 0;
                if (ucenici[i] > druzmax || ucenici[i] < (-1 * druzmax))
                    Console.WriteLine("Druzaljubivost nije u zadatim granicama");
            }

            //ucitavaju se parovi poznanika
            for (int i = 0; i < m; i++)
            {
                string[] s = Console.ReadLine().Split();
                parovi[i].prvi = int.Parse(s[0]);
                parovi[i].drugi = int.Parse(s[1]);
            }

            //ispituje se sta je najpovoljnije za svaki par i formiraju se grupe prijatelja i neprijatelja

            for (int i = 0; i < m; i++)
            {
                parovi[i].prvi--;
                parovi[i].drugi--;
                if (Math.Abs(ucenici[parovi[i].prvi]) > Math.Abs(ucenici[parovi[i].drugi]))
                {
                    if (ucenici[parovi[i].prvi] > 0)//oni su prijatelji
                    {
                        prijatelji[parovi[i].prvi]++;
                        prijatelji[parovi[i].drugi]++;
                    }
                    else if (ucenici[parovi[i].prvi] < 0)//oni su neprijatelji
                    {
                        neprijatelji[parovi[i].prvi]++;
                        neprijatelji[parovi[i].drugi]++;
                    }
                    else
                    {   //ako je druzeljubivost prvog 0, onda se odredjuje u odnosu na drugog
                        if (ucenici[parovi[i].drugi] > 0)//oni su prijatelji
                        {
                            prijatelji[parovi[i].prvi]++;
                            prijatelji[parovi[i].drugi]++;
                        }
                        else    //oni su neprijatelji
                        {
                            neprijatelji[parovi[i].prvi]++;
                            neprijatelji[parovi[i].drugi]++;
                        }
                    }
                }
                else
                {
                    if (ucenici[parovi[i].drugi] > 0)//oni su prijatelji
                    {
                        prijatelji[parovi[i].prvi]++;
                        prijatelji[parovi[i].drugi]++;
                    }
                    else if (ucenici[parovi[i].drugi] < 0)//oni su neprijatelji
                    {
                        neprijatelji[parovi[i].prvi]++;
                        neprijatelji[parovi[i].drugi]++;
                    }
                    else
                    {   //ako je druzeljubivost drugog 0, onda se odredjuje u odnosu na prvog
                        if (ucenici[parovi[i].prvi] > 0)//oni su prijatelji
                        {
                            prijatelji[parovi[i].prvi]++;
                            prijatelji[parovi[i].drugi]++;
                        }
                        else    //oni su neprijatelji
                        {
                            neprijatelji[parovi[i].prvi]++;
                            neprijatelji[parovi[i].drugi]++;
                        }
                    }
                }
            }
            long sreca = 0;
            for (int i = 0; i < n; i++)
            {
                sreca += ucenici[i] * (prijatelji[i] - neprijatelji[i]);
            }

            Console.WriteLine(sreca);
        }
    }
}