#include <iostream>
using namespace std;

void swap(unsigned long long* a, unsigned long long* b)
{
    unsigned long long t = *a;
    *a = *b;
    *b = t;
}

unsigned long long part (unsigned long long arr[], int low, int high)
{
    int pivot = arr[high];    // pivot
    int i = (low - 1);

    for (int j = low; j <= high- 1; j++)
    {
        //if current element is smaller than pivot, increment the low element
        //swap elements at i and j
        if (arr[j] <= pivot)
        {
            i++;    // increment index of smaller element
            swap(&arr[i], &arr[j]);
        }
    }
    swap(&arr[i + 1], &arr[high]);
    return (i + 1);
}

//quicksort algorithm
void quickSort(unsigned long long arr[], int low, int high)
{
    if (low < high)
    {
        //partition the array
        int pivot = part(arr, low, high);

        //sort the sub arrays independently
        quickSort(arr, low, pivot - 1);
        quickSort(arr, pivot + 1, high);
    }
}
int binarySearch(unsigned long long  arr[], int l, int r, int x)
{
    if (r >= l) {
        int mid = l + (r - l) / 2;

        // If the element is present at the middle
        // itself
        if (arr[mid] == x)
            return mid;

        // If element is smaller than mid, then
        // it can only be present in left subarray
        if (arr[mid] > x)
            return binarySearch(arr, l, mid - 1, x);

        // Else the element can only be present
        // in right subarray
        return binarySearch(arr, mid + 1, r, x);
    }

    // We reach here when element is not
    // present in array
    return -1;
}
int main()
{
    int t;
    cin>>t;
    int tt[t];
    for(int i=0;i<t;i++)
    {
    int p=1;
    int n,m;
    cin>>n>>m;
    unsigned long long a[n];
    unsigned long long b[m];
    unsigned long long x;
    for(int j=0;j<n;j++)
    {
        cin>>x;
        a[j]=x;
    }
    for(int j=0;j<m;j++)
    {
        cin>>x;
        b[j]=x;
    }
    quickSort(a,0,n-1);
    x=a[1]-a[0];
    for(int j=0;j<n-1;j++)
    {
        int z=a[j+1]-a[j];
        if(z%x!=0)
        {
            p=0;
            break;
        }
    }
    for(int j=0;j<m;j++)
    {
        int z=b[j]+x;
        if(binarySearch(a,0,n-1,z)!=-1)
        {
            p=0;
            break;
        }
        z=b[j]-x;

        if(binarySearch(a,0,n-1,z)!=-1)
        {
            p=0;
            break;
        }
    }

    tt[i]=p;
    }
    for(int i=0;i<t;i++)
    {
        cout<<tt[i]<<"\n";
    }
    return 0;
}