#include <bits/stdc++.h>

using uint = unsigned int;

auto main() -> int {
	constexpr uint N = 100'000;
	constexpr uint M = 100'000;

	int druzeljubivosti[N];
	std::pair<uint, uint> poznanstva[M];
	int prijateljstva[N];

	uint n, m;
	std::scanf("%u%u", &n, &m);

	std::memset(prijateljstva, 0, n * sizeof (int));

	for (uint i = 0; i < n; ++i)
		std::scanf("%d", druzeljubivosti + i);

	for (uint i = 0; i < m; ++i) {
		uint a, b;
		std::scanf("%u%u", &a, &b);
		poznanstva[i] = { a - 1, b - 1 };
	}

	const auto sredi_poznanstvo = [&druzeljubivosti, &poznanstva, &prijateljstva](const uint i) {
		uint uc_a, uc_b;
		std::tie(uc_a, uc_b) = poznanstva[i];

		auto d_a = druzeljubivosti[uc_a];
		auto d_b = druzeljubivosti[uc_b];

		auto diff = d_a + d_b;

		auto inc = d_a + d_b >= 0 ? 1 : -1;

		prijateljstva[uc_a] += inc;
		prijateljstva[uc_b] += inc;
	};

	for (uint i = 0; i < m; ++i) {
		sredi_poznanstvo(i);
	}

	// Ostalo je samo izracunati ukupnu srecu

	int sreca = 0;
	for (uint i = 0; i < n; ++i) {
		sreca += druzeljubivosti[i] * prijateljstva[i];
	}

	std::printf("%d\n", sreca);

	return 0;
}