#include <iostream>
#include <algorithm>
#include <set>
#include <sstream>
#include <vector>
#include <numeric>

//#define print(x) cout << #x << " = " << x << endl;

using namespace std;

int T, n, m;

//// FUNCTION TEMPLATE _Stl_bitscan_forward
//template <class _Unsigned>
//constexpr unsigned long _Stl_bitscan_forward(_Unsigned _Mask) noexcept {
//	// find the index of the least significant set bit (_BitScanForward isn't constexpr... yet :))
//	static_assert(is_unsigned_v<_Unsigned>, "Bitscan only works on bits");
//	unsigned long _Count = 0;
//	if (_Mask != 0) {
//		while ((_Mask & 1U) == 0) {
//			_Mask >>= 1;
//			++_Count;
//		}
//	}
//
//	return _Count;
//}
//
//template <class _Mt, class _Nt>
//_NODISCARD constexpr common_type_t<_Mt, _Nt> gcd(const _Mt _Mx, const _Nt _Nx) noexcept /* strengthened */ {
//	// calculate greatest common divisor
//	static_assert(_Is_nonbool_integral<_Mt> && _Is_nonbool_integral<_Nt>, "GCD requires nonbool integral types");
//
//	using _Common = common_type_t<_Mt, _Nt>;
//	using _Common_unsigned = make_unsigned_t<_Common>;
//	_Common_unsigned _Mx_magnitude = abs(_Mx);
//	_Common_unsigned _Nx_magnitude = abs(_Nx);
//	if (_Mx_magnitude == 0U) {
//		return static_cast<_Common>(_Nx_magnitude);
//	}
//
//	if (_Nx_magnitude == 0U) {
//		return static_cast<_Common>(_Mx_magnitude);
//	}
//
//	const auto _Mx_trailing_zeroes = _Stl_bitscan_forward(_Mx_magnitude);
//	const auto _Common_factors_of_2 = _Min_value(_Mx_trailing_zeroes, _Stl_bitscan_forward(_Nx_magnitude));
//	_Nx_magnitude >>= _Common_factors_of_2;
//	_Mx_magnitude >>= _Mx_trailing_zeroes;
//	do {
//		_Nx_magnitude >>= _Stl_bitscan_forward(_Nx_magnitude);
//		if (_Mx_magnitude > _Nx_magnitude) {
//			_Common_unsigned _Temp = _Mx_magnitude;
//			_Mx_magnitude = _Nx_magnitude;
//			_Nx_magnitude = _Temp;
//		}
//
//		_Nx_magnitude -= _Mx_magnitude;
//	} while (_Nx_magnitude != 0U);
//
//	return static_cast<_Common>(_Mx_magnitude << _Common_factors_of_2);
//}

int spf[100001];

void Sieve()
{
	spf[1] = 1;
	for (int i = 2; i < 100001; i++)

		spf[i] = i;

	for (int i = 4; i < 100001; i += 2)
		spf[i] = 2;

	for (int i = 3; i * i < 100001; i++)
	{
		if (spf[i] == i)
		{
			for (int j = i * i; j < 100001; j += i)

				if (spf[j] == j)
					spf[j] = i;
		}
	}
}

vector<int> Primes(int x)
{
	vector<int> ret;
	while (x != 1)
	{
		ret.push_back(spf[x]);
		x = x / spf[x];
	}
	return ret;
}

int used[460] = { 0 };

int main()
{
	Sieve();
	ios_base::sync_with_stdio(0);
	cin.tie(); cout.tie();
	cin >> T;
	stringstream ccout;
	for (int t = 1; t <= T; t++)
	{
		set<long long> nums;
		set<long long> neg;

		cin >> n >> m;
		for (int i = 0; i < n; i++)
		{
			long long x;
			cin >> x;
			nums.insert(x);
		}
		
		for (int i = 0; i < m; i++)
		{
			long long x;
			cin >> x;
			neg.insert(x);
		}

		auto it = nums.begin();
		long long a = *it;
		it++;
		long long b = *it;
		it++;
		bool cont = 1;

		long long z = b - a;

		for (; it != nums.end(); it++)
		{
			long long curr = *it - a;
			z = __gcd(z, curr);

			if (z == 1)
			{
				cont = 0;
				break;
			}
		}
		if (!cont) continue;

		it = neg.begin();

		bool flag = false;
		set<int> primes;
		if (z > 10000000)
			flag = true;
		else
		{
			vector<int> pr = Primes(z);
			primes = set<int>(pr.begin(), pr.end());
		}

		int total = 0;
		for (; it != neg.end(); it++)
		{
			if (flag)
			{
				if (abs(*it - a) % z == 0)
				{
					cont = 0;
					ccout << "0\n";
					break;
				}
			}
			else
			{
				int cnter = 0;
				if (primes.size() == 0) { ccout << "0\n"; cont = 0; break; }
				for (auto itr = primes.begin(); itr != primes.end(); itr++, cnter++)
				{
					if (used[cnter]) continue;
					if (abs(*it - a) % (long long)*itr == 0)
					{
						total++;
						used[cnter] = 1;
					}
					if (total == primes.size())
					{
						cont = 0;
						ccout << "0\n";
						break;
					}
				}
			}
		}
		memset(used, 0, 459);
		if (cont) ccout << "1\n";
	}
	cout << ccout.rdbuf();
}