#include <iostream>
#include <algorithm>
#include <vector>
using namespace std;

// Funkcija koja racuna za koliko treba da se poveca sreca u zavisnosti
// od toga kolike su druzeljubivosti poznanika u jednom poznanstvu
long long sreca(pair<int, int> poznanici, vector<int>& druzeljubivost)
{
	int indeks_prvog = poznanici.first;
	int indeks_drugog = poznanici.second;
	long long druzeljubivost_prvog = druzeljubivost[indeks_prvog];
	long long druzeljubivost_drugog = druzeljubivost[indeks_drugog];

	long long veca_druzeljubivost = max(druzeljubivost_prvog, druzeljubivost_drugog);
	long long manja_druzeljubivost = min(druzeljubivost_prvog, druzeljubivost_drugog);

	bool prijatelji;
	// Ako su ucenicima razliciti znakovi druzeljubivosti,
	// treba da budu prijatelji ako je pozitivna druzeljubivost
	// veca od apsolutne vrednosti negativne druzeljubivosti,
	// u suprotnom treba da budu neprijatelji
	if (veca_druzeljubivost >= 0 && manja_druzeljubivost <= 0)
	{
		if (veca_druzeljubivost > abs(manja_druzeljubivost))
			prijatelji = true;
		else
			prijatelji = false;
	}

	// Ako su obe druzeljubivosti pozitivne treba da budu prijatelji,
	// ako su obe druzeljubivosti negativne treba da budu neprijatelji
	else if (veca_druzeljubivost >= 0 && manja_druzeljubivost >= 0)
		prijatelji = true;
	else
		prijatelji = false;

	if (prijatelji)
		return druzeljubivost_prvog + druzeljubivost_drugog;
	else
		return -(druzeljubivost_prvog + druzeljubivost_drugog);

}

int main()
{
	// Unos
	ios_base::sync_with_stdio(false);
	cin.tie(0);
	int broj_ucenika, broj_poznanstva; cin >> broj_ucenika >> broj_poznanstva;
	vector<int> druzeljubivost(broj_ucenika + 1);
	for (int i = 1; i <= broj_ucenika; i++)
		cin >> druzeljubivost[i];
	vector<pair<int, int>> poznanici(broj_poznanstva + 1);
	for (int i = 0; i < broj_poznanstva; i++)
		cin >> poznanici[i].first >> poznanici[i].second;

	// Racunanje ukupne srece
	long long ukupna_sreca = 0;
	for (int i = 0; i < broj_poznanstva; i++)
		ukupna_sreca += sreca(poznanici[i], druzeljubivost);

	cout << ukupna_sreca;

	return 0;
}