#include <iostream>
#include <unordered_set>
#include <vector>
#include <cmath>

using namespace std;

long long Euclid(long long a, long long b)
{
	if(b == 0) return a;
	return Euclid(b, a%b);
}


int main()
{
	ios_base::sync_with_stdio(false);
	cin.tie(0);
	
	int t;
	cin >> t;
	vector<int> sol;
	
	while(t > 0)
	{
		--t;
		int n, m;
		cin >> n >> m;
		
		long long a[n];
		long long b[m];
		
		for(int i = 0; i < n; ++i)
			cin >> a[i];
		
		for(int i = 0; i < m; ++i)
			cin >> b[i];
			
		int min_el = a[0];
		for(int i = 1; i < n; ++i)
			if(a[i] < min_el) min_el = a[i];
			
		for(int i = 0; i < n; ++i)
			a[i]-=min_el;
			
		for(int i = 0; i < m; ++i)
			b[i] = abs(b[i]-min_el);
			
		int nzd = a[0];
		for(int i = 1; i < n; ++i)
		{
			nzd = Euclid(nzd, a[i]);
		}
		if(nzd == 1)
		{
			sol.push_back(0);
			continue;
		}
		
		bool succ = true;
		for(int i = 0; i < m; ++i)
		{
			if(Euclid(nzd, b[i]) != 1) succ = false;
		}
		if(!succ) sol.push_back(0);
		else sol.push_back(1);
	}
	
	for(int i = 0; i < sol.size(); ++i)
		cout << sol[i] << endl;
}