#include <stdlib.h>
#include <stdio.h>

void Swap (long long* x, long long* y)
{
    long long t = *x;
    *x = *y;
    *y = t;
}

void Sort (long long* A, long l, long r)
{
    if (l<r)
    {
        long long piv = A[r];
        long long i = l-1;
        for (long j=l; j<r; j++)
            if (A[j]>piv)
            {
                i++;
                Swap (&A[i], &A[j]);
            }
        Swap (&A[i+1], &A[r]);

        Sort (A, l, i);
        Sort (A, i+2, r);
    }
}

long long NZD (long long x, long long y)
{
    long long t;
    while (y!=0)
    {
        t = y;
        y = x%y;
        x = t;
    }

    return x;
}

int main()
{
    int T;
    scanf ("%d", &T);

    for (int k=0; k<T; k++)
    {
        long N, M;
        scanf ("%ld%ld", &N, &M);

        long long* A = (long long*)malloc (N*sizeof (long long));
        long long nzd = A[1]-A[0];
        for (long j=2; j<N; j++)
        {
            nzd = NZD (A[j]-A[j-1], nzd);
            if (nzd==1)
                break;
        }

        int ind = 1;
        long long b;
        for (long j=0; j<M; j++)
        {
            scanf ("%lld", &b);
            if ((b-A[0])%nzd==0)
                ind = 0;
        }
        printf ("%d\n", ind);
    }

    return 0;
}