#include <iostream>
#include <bits/stdc++.h>

using namespace std;

typedef long long ll;

const ll mxN = 75010;

ll A[mxN];
ll B[mxN];
/**https://en.wikipedia.org/wiki/Binary_GCD_algorithm  O(logN)  */
ll gcd( ll u,  ll v)
{
    // Base cases
    //  gcd(n, n) = n
    if (u == v)
        return u;

    //  Identity 1: gcd(0, n) = gcd(n, 0) = n
    if (u == 0)
        return v;
    if (v == 0)
        return u;

    if (u % 2 == 0) { // u is even
        if (v % 2 == 1) // v is odd
            return gcd(u/2, v); // Identity 3
        else // both u and v are even
            return 2 * gcd(u/2, v/2); // Identity 2

    } else { // u is odd
        if (v % 2 == 0) // v is even
            return gcd(u, v/2); // Identity 3

        // Identities 4 and 3 (u and v are odd, so u-v and v-u are known to be even)
        if (u > v)
            return gcd((u - v)/2, v);
        else
            return gcd((v - u)/2, u);
    }
}

int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    ll N,M,T;
    cin >> T;
    while(T--)
    {
        cin >> N >> M;
        cin >> A[0];
        ll minGod = A[0];
        for(int i = 1; i < N; i++)
        {
            cin >> A[i];
            minGod = min(minGod, A[i]);
        }
        for(int i = 0; i < M; i++)
        {
            cin >> B[i];
        }
        ll factor = abs(A[1] - A[0]);
        ll newFactor;
        for(int i = 2; i < N; i++)
        {
            newFactor = abs(A[i] - A[i - 1]);
            factor = gcd(factor, newFactor);
            if(factor == 1)
            {
                break;
            }
        }
        bool ok = true;
        for(int i = 0; i < M; i++)
        {
            if((B[i] - minGod) % factor == 0)
            {
                ok = false;
                break;
            }
        }
        cout << ok << "\n";
    }
}










            /*
            if(newFactor > factor)
            {
                ll ostatak = newFactor % factor;
                if(ostatak != 0)
                {
                    if(factor % ostatak == 0 && newFactor % ostatak == 0)
                    {
                        factor = ostatak;
                    }
                    else
                    {
                        ok = false;
                        break;
                    }
                }
            }
            else
            {
                ll ostatak = factor % newFactor;
                if(ostatak != 0)
                {
                    if(factor % ostatak == 0 && newFactor % ostatak == 0)
                    {
                        factor = ostatak;
                    }
                    else
                    {
                        ok = false;
                        break;
                    }
                }
            }*/