#include <iostream>
#include <algorithm>
#include <vector>
using namespace std;
#define ll long long

ll gcd(ll a, ll b)
{
	while (b != 0)
	{
		ll temp = b;
		b = a % b;
		a = temp;
	}
	return a;
}

void solve_test_case()
{
	int n, m; cin >> n >> m;
	vector<ll> elements1(n), elements2(m);
	for (size_t i = 0; i < n; i++)
		cin >> elements1[i];
	sort(elements1.begin(), elements1.end());

	for (size_t i = 0; i < m; i++)
		cin >> elements2[i];
	sort(elements2.begin(), elements2.end());

	// Find gcd of all steps in elements1
	ll max_step = elements1[1] - elements1[0];
	for (size_t i = 0; i < n-1; i++)
	{
		ll current_step = elements1[i + 1] - elements1[i];
		max_step = gcd(max_step, current_step);
	}

	for (size_t i = 0; i < m; i++)
	{
		ll illegal_step = abs(elements2[i] - elements1[0]);
		if (illegal_step % max_step == 0)
		{
			cout << 0 << "\n";
			return;
		}
	}

	cout << 1 << "\n";
}

int main()
{
	ios::sync_with_stdio(false);
	
	int tests_count; cin >> tests_count;
	for (size_t test_no = 0; test_no < tests_count; test_no++)
	{
		solve_test_case();
	}

	return 0;
}