using System;
using System.Collections.Generic;
using System.Linq;

namespace Zadatak2
{
    public class Poznanstvo
    {
        public Takmicar Poznanik1 { get; private set; }
        public Takmicar Poznanik2 { get; private set; }
        public bool Prijatelji { get; private set; }

        public Poznanstvo(Takmicar poznanik1, Takmicar poznanik2, bool prijatelji)
        {
            Poznanik1 = poznanik1;
            Poznanik2 = poznanik2;
            Prijatelji = prijatelji;
        }
    }

    public class Takmicar
    {
        public int Druzeljubivost { get; private set; }
        public List<Poznanstvo> Poznanstva { get; private set; }

        public Takmicar(int druz)
        {
            Druzeljubivost = druz;
            Poznanstva = new List<Poznanstvo>();
        }

        private List<Poznanstvo> Prijateljstva
        {
            get
            {
                return Poznanstva.Where(x => x.Prijatelji).ToList();
            }
        }

        private List<Poznanstvo> Neprijateljstva
        {
            get
            {
                return Poznanstva.Where(x => !x.Prijatelji).ToList();
            }
        }

        public int Sreca
        {
            get
            {
                return Druzeljubivost * (Prijateljstva.Count - Neprijateljstva.Count);
            }
        }
    }

    class Program
    {
        static void Main(string[] args)
        {
            var nmInputStr = Console.ReadLine();

            var nmSplit = nmInputStr.Split(' ');
            if (nmSplit.Length != 2)
            {
                Console.WriteLine("Morate uneti tacno 2 broja");
                return;
            }

            var n = int.Parse(nmSplit[0]);
            var m = int.Parse(nmSplit[1]);


            var takmicari = new List<Takmicar>(n);

            for (int i = 0; i < n; i++)
            {
                var druzeljubivost = int.Parse(Console.ReadLine());

                takmicari.Add(new Takmicar(druzeljubivost));
            }


            for (int i = 0; i < m; i++)
            {
                var poznaniciStr = Console.ReadLine();
                var poznaniciArray = poznaniciStr.Split(' ').Select(x => int.Parse(x)).ToArray();
                if (poznaniciArray.Length != 2)
                {
                    Console.WriteLine("Morate uneti tacno 2 broja za poznanstvo");
                    return;
                }

                //zadatak kaze da indeksi pocinju od 1, nasi indeksi pocinju od 0
                int poznanik1Ind = poznaniciArray[0] - 1;
                int poznanik2Ind = poznaniciArray[1] - 1;

                var poz1 = takmicari[poznanik1Ind];
                var poz2 = takmicari[poznanik2Ind];

                bool prijatelji;

                // da li je prvi poznanik u poznanstvu vise druzeljubiv od drugog?
                if (Math.Abs(poz1.Druzeljubivost) > Math.Abs(poz2.Druzeljubivost))
                {
                    //prvi - ako je druzeljubiv (> 0) onda je poznanstvo prijateljsko
                    //ako nije druzeljubiv, onda je neprijateljstvo
                    prijatelji = poz1.Druzeljubivost > 0;
                }
                else
                {
                    prijatelji = poz2.Druzeljubivost > 0;
                }

                var poznanstvo = new Poznanstvo(poz1, poz2, prijatelji);
                poz1.Poznanstva.Add(poznanstvo);
                poz2.Poznanstva.Add(poznanstvo);
            }

            var sreca = takmicari.Sum(x => x.Sreca);

            Console.WriteLine(sreca);
        }
    }
}