using System;
using System.Collections.Generic;
using System.Linq;

namespace Zadatak3
{
    public class Takmicar
    {
        public List<long> Prihvacene { get; private set; }
        public List<long> Odbacene { get; private set; }

        public Takmicar(List<long> prihvacene, List<long> odbacene)
        {
            Prihvacene = prihvacene.OrderBy(x => x).ToList();
            Odbacene = odbacene.OrderBy(x => x).ToList();
        }

        public long MagicNumber()
        {
            long? minDiff = null;

            for (int i = 0; i < Prihvacene.Count - 1; i++)
            {
                long latestDiff = Prihvacene[i + 1] - Prihvacene[i];
                minDiff = minDiff.HasValue ? Math.Min(minDiff.Value, latestDiff) : latestDiff;
            }

            var candidates = Divisors(minDiff.Value);
            foreach (var candidate in candidates)
            {
                var matchesAccepted = MatchesCandidate(Prihvacene, candidate, Prihvacene[0]);
                var matchesRejected = MatchesCandidate(Odbacene, candidate, Prihvacene[0]);

                if (matchesAccepted && !matchesRejected)
                    return candidate;
            }

            return -1;
        }

        private bool MatchesCandidate(IEnumerable<long> years, long candidate, long shift)
        {
            foreach (var yr in years)
            {
                var shifted = yr - shift;
                if (shifted % candidate != 0)
                    return false;
            }
            return true;
        }

        public static IEnumerable<long> Divisors(long number)
        {
            List<long> factors = new List<long>();
            var max = (long)Math.Sqrt(number);
            for (int factor = 1; factor <= max; ++factor)
            {
                if (number % factor == 0)
                {
                    factors.Add(factor);
                    if (factor != number / factor)
                    {
                        yield return number / factor;
                    }
                }
            }
        }
    }

    class Program
    {
        static void Main(string[] args)
        {
            var brTakmicara = int.Parse(Console.ReadLine());
            var takmicari = new List<Takmicar>(brTakmicara);

            for (int i = 0; i < brTakmicara; i++)
            {
                var strPrihvaceneOdbijene = Console.ReadLine();
                var tokenized = strPrihvaceneOdbijene.Split(' ').Select(x => int.Parse(x)).ToArray();

                try
                {
                    int brPrihvacene = tokenized[0];
                    int brOdbijene = tokenized[1];
                }
                catch (IndexOutOfRangeException)
                {
                    Console.WriteLine("Morate uneti tacno 2 broja - broj prihvacenih i broj odbijenih");
                    return;
                }

                var strPrihvacene = Console.ReadLine();
                var godinePrihvacene = strPrihvacene.Split(' ').Select(x => long.Parse(x)).ToList();

                var strOdbijene = Console.ReadLine();
                var godineOdbijene = strOdbijene.Split(' ').Select(x => long.Parse(x)).ToList();


                takmicari.Add(new Takmicar(godinePrihvacene, godineOdbijene));
            }

            foreach (var takmicar in takmicari)
            {
                if (takmicar.MagicNumber() > 0)
                    Console.WriteLine("1");
                else
                    Console.WriteLine("0");
            }


        }
    }
}