#include <bits/stdc++.h>

using namespace std;
typedef long long ll;
const ll mod = 1e9 + 7;

const int N = 2e5 + 7;
ll a[N], f[N], inv[N];

ll bin_pow(ll x, ll n) {
    ll r = 1;
    while (n) {
        if (n & 1) {
            r *= x;
            r %= mod;
        }
        x *= x; x %= mod;
        n >>= 1;
    }
    return r;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(0); cout.tie(0);
    int n, k; cin >> n >> k;
    for (int i = 1; i <= n; i++) {
        cin >> a[i];
    }
    f[0] = inv[0] = 1;
    for (int i = 1; i < N; i++) {
        a[i] = (a[i - 1] + a[i]) % mod;
        f[i] = f[i - 1] * i % mod;
        inv[i] = bin_pow(f[i], mod - 2);
    }
    if (k == 0) {
        return cout << a[n] << endl, 0;
    }
    ll r = 0;
    for (int i = 1; i <= n; i++) {
        for (int j = i; j <= n; j++) {
            ll c = f[i + k - 2] * inv[k - 1] % mod * inv[i - 1] % mod;
            ll d = f[n - j + k - 1] * inv[k - 1] % mod * inv[n - j] % mod;
            r += (a[j] - a[i - 1]) * c % mod * d % mod;
            r %= mod;
        }
    }
    cout << (r + mod) % mod << endl;
    return 0;
}