#include <iostream>
#define MOD 1000000007

using namespace std;

long long niz[200000];

long long exponential(long long a, long long m){
    if (m == 0) return 1;
    long long s = exponential(a, m/2) % MOD;
    s = (s*s) % MOD;
    if (m % 2 == 0) return s;
    return (s * a) % MOD;
}

long long binCoeff(int n, int k){
    return niz[n] * exponential(niz[k], MOD - 2) % MOD * exponential(niz[n-k], MOD - 2) % MOD;
}

int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(0);
    
    int n, k;
    cin >> n >> k;
    int A[n];
    for (int i = 0; i < n; ++i){
        cin >> A[i];
    }
    niz[0] = 1;
    for (int i = 1; i < n+k; ++i){
        niz[i] = niz[i-1] * i % MOD;
    }
    long long result = 0;
    for (int i = 1; i <= n; ++i){
        result += ((A[i-1] % MOD) * ((binCoeff(n-i+k, k) % MOD) * (binCoeff(i+k-1, k) % MOD)) % MOD) % MOD;
    }
    cout << result;
    return 0;
}