#include <bits/stdc++.h>
using namespace std;

#define ulong uint64_t
#define long int64_t
#define endl '\n'

#ifdef OFFLINE
	#define logan(...) logg(#__VA_ARGS__, __VA_ARGS__)
	template<class Arg>
	void logg(const char* name, Arg&& arg){ cerr << name << ": " << arg << '\n'; }
	template<class Arg, class ... Args>
	void logg(const char* name, Arg&& arg, Args&& ... args){
		char *next = (char*)name, *cand;
		int depth = 0;
		do{
			if(depth){ next = strchr(next+1, ')'); --depth; }
			else if((cand = strchr(next+1, '('))){ next = cand; ++depth; }
			else{ next = strchr(next+1, ','); }
		}while(depth);
		cerr.write(name, next-name) << ": " << arg << ",";
		logg(next+1, args...);
	}
	#define timeme 1.0*clock()/CLOCKS_PER_SEC
#else
	#define logan(...) {}
	#define timeme {}
#endif

template<ulong m>
struct modint {
	ulong x;

	modint() : x(0) {}
	modint(long arg) {
		x = arg%m;
		x = (arg < 0 ? arg+m : arg);
	}

	modint& operator+= (const modint& other) {
		x += other.x;
		if (x >= m) x -= m;
		return *this;
	}

	modint& operator*= (const modint& other) {
		x = (x * other.x) % m;
		return *this;
	}

	modint& operator-= (const modint& other) {
		x += m - other.x;
		if(x >= m) x -= m;
		return *this;
	}

	modint operator+ (const modint& other) const {
		modint tmp = *this;
		tmp += other;
		return tmp;
	}

	modint operator- (const modint& other) const {
		modint tmp = *this;
		tmp -= other;
		return tmp;
	}

	modint operator* (const modint& other) const {
		modint tmp = *this;
		tmp *= other;
		return tmp;
	}

	explicit operator ulong () const { return x; }
	modint& operator++ () {
		++x;
		if(x == m) x = 0;
		return *this;
	}

	modint& operator-- () {
		if(x == 0) x = m-1;
		else --x;
		return *this;
	}

	modint operator++ (int) {
		modint tmp = *this;
		++*this;
		return tmp;
	}

	modint operator-- (int) {
		modint tmp = *this;
		--*this;
		return tmp;
	}

	bool operator== (const modint& other) const { return x == other.x; }
	bool operator!= (const modint& other) const { return x != other.x; }

	modint operator^ (ulong arg) const {
		if(arg == 0) return 1;
		if (arg == 1) return x;
		auto t = *this ^ (arg >> 1);
		t *= t;
		if (arg & 1) t *= *this;
		return t;
	}

	modint inv(ulong exp = m - 2) const {
		return *this ^ exp;
	}
	
	friend ostream& operator<< (ostream& out, const modint& x) { out << x.x; return out; }
	friend istream& operator>> (istream& in, modint& x) { in >> x.x; return in; }
};

const ulong MOD = 1'000'000'007;
typedef modint<MOD> mint;

mint a[200'001];

int main(){
	ios_base::sync_with_stdio(false);
	cin.tie(nullptr);
	cout.tie(nullptr);
	cerr.tie(nullptr);

	long n, k; cin >> n >> k;
	for(long i = 0; i < n; ++i){
		cin >> a[i];
	}


	mint sum = 0;
	if(k == 0){
		for(long i = 0; i < n; ++i)
			sum += a[i];

		cout << sum << endl;
		return 0;
	}

	for(long i = 0; i < n; ++i){
		long ind = (i+1)*(n-i);
		long pow = (n*(n+1))/2;
		sum += a[i]*mint(ind)*(mint(pow)^(k-1));
	}

	cout << sum << endl;

}