#include <bits/stdc++.h>
using namespace std;

#define long int64_t
#define ulong uint64_t
#define endl '\n'

#ifdef OFFLINE
	#define logan(...) logg(#__VA_ARGS__, __VA_ARGS__)
	template<class Arg>
	void logg(const char* name, Arg&& arg){ cerr << name << ": " << arg << '\n'; }
	template<class Arg, class ... Args>
	void logg(const char* name, Arg&& arg, Args&& ... args){
		char *next = (char*)name, *cand;
		int depth = 0;
		do{
			if(depth){ next = strchr(next+1, ')'); --depth; }
			else if((cand = strchr(next+1, '('))){ next = cand; ++depth; }
			else{ next = strchr(next+1, ','); }
		}while(depth);
		cerr.write(name, next-name) << ": " << arg << ",";
		logg(next+1, args...);
	}
	#define timeme 1.0*clock()/CLOCKS_PER_SEC
#else
	#define logan(...) {}
	#define timeme {}
#endif

//I really recommend that you define long as int64_t and ulong as uint64_t

template<ulong m>
struct modint {
	ulong x;

	modint() : x(0) {}
	modint(long arg) {
		x = arg%m;
		x = (arg < 0 ? arg+m : arg);
	}

	modint& operator+= (const modint& other) {
		x += other.x;
		if (x >= m) x -= m;
		return *this;
	}

	modint& operator*= (const modint& other) {
		x = (x * other.x) % m;
		return *this;
	}

	modint& operator-= (const modint& other) {
		x += m - other.x;
		if(x >= m) x -= m;
		return *this;
	}

	modint operator+ (const modint& other) const {
		modint tmp = *this;
		tmp += other;
		return tmp;
	}

	modint operator- (const modint& other) const {
		modint tmp = *this;
		tmp -= other;
		return tmp;
	}

	modint operator* (const modint& other) const {
		modint tmp = *this;
		tmp *= other;
		return tmp;
	}

	explicit operator ulong () const { return x; }
	modint& operator++ () {
		++x;
		if(x == m) x = 0;
		return *this;
	}

	modint& operator-- () {
		if(x == 0) x = m-1;
		else --x;
		return *this;
	}

	modint operator++ (int) {
		modint tmp = *this;
		++*this;
		return tmp;
	}

	modint operator-- (int) {
		modint tmp = *this;
		--*this;
		return tmp;
	}

	bool operator== (const modint& other) const { return x == other.x; }
	bool operator!= (const modint& other) const { return x != other.x; }

	modint operator^ (ulong arg) const {
		if(arg == 0) return 1;
		if (arg == 1) return x;
		auto t = *this ^ (arg >> 1);
		t *= t;
		if (arg & 1) t *= *this;
		return t;
	}

	modint inv(ulong exp = m - 2) const {
		return *this ^ exp;
	}
	
	friend ostream& operator<< (ostream& out, const modint& x) { out << x.x; return out; }
	friend istream& operator>> (istream& in, modint& x) { in >> x.x; return in; }
};

const ulong MOD = 1'000'000'007;
typedef modint<MOD> mint;

struct pr{
	int a, b;
};

basic_string<pr> a;
mint d[1'000'002][27];

int main(){
	ios_base::sync_with_stdio(false);
	cin.tie(nullptr);
	cout.tie(nullptr);
	cerr.tie(nullptr);

	int n; cin >> n;
	string s; cin >> s;

	int cnt = 1;
	int cur = s[0]-'A'+1;
	for(int i = 1; i < n; ++i){
		if(s[i]-'A'+1 != cur){
			a += {cur, cnt};
			cur = s[i]-'A'+1;
			cnt = 1;
		}else{
			++cnt;
		}
	}
	a += {cur, cnt};

	d[0][0] = 1;
	for(int i = 1; i <= n; ++i){
		for(int j = 1; j <= 26; ++j){
			if(a[i-1].a == j){
				d[i][j] = d[i-1][j] + d[i-1][j-1] * a[i-1].b;
			}else{
				d[i][j] = d[i-1][j];
			}
		}
	}

	cout << d[n-1][26] << endl;

}