#include <bits/stdc++.h>
using namespace std;

typedef long long ll;
const int MX = 5e5 + 5;
const ll MOD = 1e9 + 7;
ll fact[MX];
ll factinv[MX];

ll mod_exp(ll x, ll y, ll mod) {
    ll res = 1;
    while(y > 0) {
        if(y & 1) res = res*x % mod;
        y >>= 1;
        x = x*x % mod;
    }
    return res;
}

void pre() {
    fact[0] = 1;
    factinv[0] = 1;
    for(ll i = 1; i < MX; i++) {
        fact[i] = (i * fact[i - 1]) % MOD;
        factinv[i] = mod_exp(fact[i], MOD - 2, MOD);
    }
}

ll binom(ll n, ll k) {
    ll num = fact[n];
    ll kinv = factinv[k];
    ll nkinv = factinv[n - k];
    ll ret = (num * kinv) % MOD;
    return (ret * nkinv) % MOD;
}

int main() {
    ios_base::sync_with_stdio(0);cin.tie(0);cout.tie(0);

    pre();
    int n,k;
    cin>>n>>k;

    ll arr[n];
    for(int i=0;i<n;++i)cin >> arr[i];

    ll ans = 0;
    for(int i=0;i<n;++i) {
        int left = i;
        int right = n - i - 1;

        ll multleft = binom(left + k, k);
        ll multright = binom(right + k, k);
        ll mult = (multleft * multright) % MOD;

        ans = (ans + mult * arr[i]) % MOD;
    }

    cout << ans << '\n';
}