#include <iostream>
#include <algorithm>
#include <vector>
#include <numeric>
#include <unordered_map>
using namespace std;
#define ll long long
vector<vector<vector<ll>>> dp;
const ll mod = 1e9 + 7;

ll solve(const vector<ll>& elements, int l, int r, int k)
{
	if (dp[k][l][r] > -1)
		return dp[k][l][r];
	if (k == 0)
	{		
		ll sum = 0;
		for (size_t i = l; i <= r; i++)
		{
			sum += elements[i];
			sum %= mod;
		}
		dp[k][l][r] = sum;
		return sum;
	}
	ll sum = 0;
	for (size_t i = l; i <= r; i++)
	{
		for (size_t j = i; j <= r; j++)
		{
			sum += solve(elements, i, j, k - 1);
			sum %= mod;
		}
	}
	dp[k][l][r] = sum;
	return sum;
}

int main()
{
	ios::sync_with_stdio(false);
	cin.tie(0);
	int n, k; cin >> n >> k;
	vector<ll> elements(n);
	for (size_t i = 0; i < n; i++)
		cin >> elements[i];
	dp = vector<vector<vector<ll>>>(k+1, vector<vector<ll>>(n,vector<ll>(n,-1)));

	cout << solve(elements, 0, n - 1, k) << "\n";
	return 0;
}