// C++ implementation of the approach 
#include <bits/stdc++.h> 
using namespace std; 

// Function that returns the count of 
// squares parallel to both X and Y-axis 
// from a given set of points 
int countSquares(int* X, int* Y, int N) 
{ 
	// Initialize result 
	int count = 0; 

	// Initialize a set to store points 
	set<pair<int, int> > points; 

	// Initialize a map to store the 
	// points in the same vertical line 
	map<int, vector<int> > vertical; 

	// Store the points in a set 
	for (int i = 0; i < N; i++) { 
		points.insert({ X[i], Y[i] }); 
	} 

	// Store the points in the same vertical line 
	// i.e. with same X co-ordinates 
	for (int i = 0; i < N; i++) { 
		vertical[X[i]].push_back(Y[i]); 
	} 

	// Check for every two points 
	// in the same vertical line 
	for (auto line : vertical) { 
		int X1 = line.first; 
		vector<int> yList = line.second; 

		for (int i = 0; i < yList.size(); i++) { 
			int Y1 = yList[i]; 
			for (int j = i + 1; j < yList.size(); j++) { 
				int Y2 = yList[j]; 
				int side = abs(Y1 - Y2); 
				int X2 = X1 + side; 

				// Check if other two point are present or not 
				if (points.find({ X2, Y1 }) != points.end() 
				and points.find({ X2, Y2 }) != points.end()) 
					count++; 
			} 
		} 
	} 

	return count; 
} 

// Driver Code 
int main() 
{ 
	int X[] = {1,1}, Y[] = { 3,3 }; 

	int N = sizeof(X) / sizeof(X[0]); 

	cout << countSquares(X, Y, N)<<"\n"; 

	return 0; 
}