#include <bits/stdc++.h>

using namespace std;

struct Result
{
    int s;
    int e;
    int k;

    Result()
    {
        s = 0;
        e = 0;
        k = 0;
    }

    Result(int s, int e, int k)
    {
        this->s = s;
        this->e = e;
        this->k = k;
    }

    bool operator==(const Result& r1) const
    {
        return (this->s == r1.s && this->e == r1.e && this->k == r1.k);
    }

    struct HashFunction
    {
        size_t operator()(const Result& r) const
        {
          size_t s_hash = hash<int>()(r.s);
          size_t e_hash = hash<int>()(r.e);
          size_t k_hash = hash<int>()(r.k);
          return s_hash ^ e_hash ^ k_hash;
        }
    };
};

unordered_map<Result, long long, Result::HashFunction> stored_results;

long long f(int arr[], int s, int e, int k)
{
    long long res = 0;
    if(k == 0)
    {
        for(int i = s; i <= e; i++)
            res += arr[i];
        stored_results[Result(s, e, k)] = res;
        return res;
    }

    for(int i = s; i <= e; i++)
    {
        for(int j = i; j <= e; j++)
        {
            Result r(i, j, k-1);
            if (stored_results.find(r) != stored_results.end())
            {
                res += stored_results[r];
            }
            else
            {
                int temp_res = f(arr, i, j, k-1);
                stored_results[Result(i, j, k-1)] = temp_res;
                res += temp_res;
            }
        }
    }

    stored_results[Result(s, e, k)] = res;
    return res;
}

int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);

    int n, k;
    cin >> n >> k;
    int arr[n];
    for(int i = 0; i < n; i++)
    {
        cin >> arr[i];
    }

    cout << f(arr, 0, n-1, k) % 1000000007 << endl;

    return 0;
}