#include <iostream>
#include <vector>
#include <algorithm>
#include <map>
#include <set>
#include <string>
using namespace std;

#define MOD 1000000007

int main()
{
	int n; cin >> n;
	string s; cin >> s;
	vector<set<int, greater<int>>> letter_positions(26);
	for (int i = 0; i < n; i++)
	{
		int letter = s[i] - 'A';
		letter_positions[letter].insert(i);
	}

	vector<long long> dp(n);
	map<int, long long> prefix_letter;
	long long current_prefix = 0;
	for (int z_position : letter_positions['Z' - 'A'])
	{
		dp[z_position] = 1;
		current_prefix += dp[z_position];
		prefix_letter[z_position] = current_prefix;
	}

	for (int letter = 'Y' - 'A'; letter >= 'A' - 'A'; letter--)
	{
		map<int, long long> new_prefix_letter;
		long long current_prefix = 0;
		for (int letter_pos : letter_positions[letter])
		{
			auto it = prefix_letter.lower_bound(letter_pos);
			dp[letter_pos] = it != prefix_letter.end() ? it->second : 0;
			current_prefix = (current_prefix + dp[letter_pos]) % MOD;
			new_prefix_letter[letter_pos] = current_prefix;
		}
		prefix_letter = new_prefix_letter;
	}

	long long solution = 0;
	for (int a_position : letter_positions['A' - 'A'])
		solution = (solution + dp[a_position]) % MOD;

	cout << solution;
}