#include <iostream>
#include <algorithm>
#include <vector>
#include <numeric>
#include <unordered_map>
using namespace std;
#define ll long long
vector<vector<vector<ll>>> dp_recursive;
const ll mod = 1e9 + 7;

ll solve(const vector<ll>& elements, int l, int r, int k)
{
	if (dp_recursive[k][l][r] > -1)
		return dp_recursive[k][l][r];
	if (k == 0)
	{		
		ll sum = 0;
		for (size_t i = l; i <= r; i++)
		{
			sum += elements[i];
			sum %= mod;
		}
		dp_recursive[k][l][r] = sum;
		return sum;
	}
	ll sum = 0;
	for (size_t i = l; i <= r; i++)
	{
		for (size_t j = i; j <= r; j++)
		{
			sum += solve(elements, i, j, k - 1);
			sum %= mod;
		}
	}
	dp_recursive[k][l][r] = sum;
	return sum;
}
ll mod_add(ll a, ll b)
{
	return (a + b) % mod;
}

class prefix_matrix
{
private:
	vector<vector<ll>> prefix;
public:
	prefix_matrix(const vector<vector<ll>>& elements)
	{
		prefix = elements;
		prefix[0][0] = elements[0][0]%mod;

		for (int i = 1; i < elements.size(); i++)
			prefix[i][0] = (prefix[i - 1][0] + elements[i][0])%mod;
		for (int i = 1; i < elements[0].size(); i++)
			prefix[0][i] = (prefix[0][i - 1] + elements[0][i])%mod;

		for (int i = 1; i < elements.size(); i++) {
			for (int j = 1; j < elements[0].size(); j++)
			{
				prefix[i][j] = prefix[i - 1][j] + prefix[i][j - 1]
					- prefix[i - 1][j - 1] + elements[i][j];
				prefix[i][j] %= mod;
			}
		}
	}
	ll query(int a, int b)
	{
		ll left = 0, up = 0, intersection = 0;
		if (a > 0)
		{
			left = prefix[b][a - 1];
			up = prefix[a - 1][b];
			intersection = prefix[a - 1][a - 1];
		}

		ll result = prefix[b][b] - left - up + intersection;

		return result%mod;
	}
};

int main()
{
	ios::sync_with_stdio(false);
	cin.tie(0);
	int n, k; cin >> n >> k;
	vector<ll> elements(n);
	for (size_t i = 0; i < n; i++)
		cin >> elements[i];
	
	if (n <= 50 && k <= 50)
	{
		dp_recursive = vector<vector<vector<ll>>>(k + 1, vector<vector<ll>>(n, vector<ll>(n, -1)));
		ll solution = solve(elements, 0, n - 1, k);
		solution = (solution + mod) % mod;
		cout << solution << "\n";
	}
	else
	{
		auto dp = vector<vector<ll>>(n,vector<ll>(n,0));
		vector<ll> prefix(n);
		prefix[0] = elements[0];
		for (int i = 1; i < n; i++)
			prefix[i] = prefix[i - 1] + elements[i];

		for (size_t l = 0; l < n; l++)
		{
			for (size_t r = l; r < n; r++)
			{
				if (l == 0)
					dp[l][r] = prefix[r];
				else
					dp[l][r] = prefix[r] - prefix[l - 1];
			}
		}

		for (size_t current_k = 1; current_k <= k; current_k++)
		{
			auto pref = prefix_matrix(dp);
			for (size_t l = 0; l < n; l++)
			{
				for (size_t r = l; r < n; r++)
				{
					dp[l][r] = pref.query(l,r);
				}
			}
		}
		ll solution = dp[0][n - 1];
		cout << (solution + mod) % mod << "\n";
	}
	return 0;
}