using System;
using System.Linq;

namespace Zadatak3
{
    class Zadatak3
    {
        static void Main(string[] args)
        {
            int brojElem;
            int k;

            var inputArray = Console.ReadLine().Split(' ');
            if (inputArray.Length != 2)
            {
                throw new ArgumentException("Morate uneti dva cela broja");
            }

            if (!int.TryParse(inputArray[0], out brojElem))
            {
                throw new ArgumentException("Prva stavka mora biti ceo broj N");
            }

            if (!int.TryParse(inputArray[1], out k))
            {
                throw new ArgumentException("Druga stavka mora biti ceo broj k");
            }

            var inputNiz = Console.ReadLine().Split(' ');
            if (inputNiz.Length != brojElem)
            {
                throw new ArgumentException("Broj unesenih elemenata ne odgovara deklarisanoj velicini niza N");
            }

            var niz = new uint[brojElem];
            try
            {
                niz = inputNiz.Select(uint.Parse).ToArray();
            }
            catch (FormatException)
            {
                throw new ArgumentException("Uneseni element niza nije ceo broj");
            }



            var funcBroj = Funkcija(niz, 0, niz.Length, k);

            var modValue = 1e9 + 7;

            var result = funcBroj % modValue;
            Console.WriteLine(result);
        }


        static ulong Funkcija(uint[] niz, int offset, int count, int k)
        {
            ulong suma = 0;

            if (k == 0)
            {
                for (int i = offset; i < (offset + count); i++)
                {
                    suma += niz[i];
                }
            }
            else
            {
                for (int i = offset; i < (offset + count); i++)
                {
                    for (int j = i; j < (offset + count); j++)
                    {
                        suma += Funkcija(niz, i, j - i + 1, k - 1);
                    }
                }
            }

            return suma;
        }
    }
}