#include <iostream>

using num = unsigned long long;
static constexpr size_t num_max_dec_digits = 15;

char buffer[num_max_dec_digits + 1];

void fastscan(num& x)
{    
    num c;
    x = 0;    
    
    do c = getchar();
    while (c < '0' || c > '9');

    do 
    {
        x = (x << 1) + (x << 3) + c - 48;
        c = getchar();
    } while (c >= '0' && c <= '9');    
}

void fastprint(num x)
{    
    buffer[num_max_dec_digits] = '\0';    

    int i = 0;
    do
    {
        buffer[(num_max_dec_digits - 1) - (i++)] = x % 10 + '0';
        x /= 10;
    } while (x != 0);

    puts(buffer + num_max_dec_digits - i);
} 
 
int main()
{
    num X, Y, T;

    fastscan(X);
    fastscan(Y); 
    fastscan(T);
        
    int n = T / X;
    int m = T - n * X;

    fastprint((n * (X + Y) + m));    

	return 0;
}