#include <iostream>
#include <vector>
#include <algorithm>
#include <map>
using namespace std;
#define ll long long

ll solve_query_bruteforce(const vector<ll>& elements, int l, int r, int k)
{
	ll sum = 0;
	for (size_t i = l; i <= r; i += k)
		sum += elements[i];
	return sum;
}

vector<ll> bruteforce(const vector<ll>& elements, const vector<vector<ll>> queries)
{
	int n = elements.size();
	int query_count = queries.size();
	vector<ll> solutions(query_count);
	for (size_t query_no = 0; query_no < query_count; query_no++)
	{
		int l = queries[query_no][0];
		int r = queries[query_no][1];
		int k = queries[query_no][2];

		solutions[query_no] = solve_query_bruteforce(elements, l, r, k);
	}
	return solutions;
}

vector<ll> solve(const vector<ll>& elements, const vector<vector<ll>>& queries)
{
	int max_base = 300;
	auto prefix_sums = vector<vector<vector<ll>>>(max_base+1, vector<vector<ll>>());
	for (int base = 1; base <= min(max_base, (int)elements.size()); base++)
	{
		prefix_sums[base] = vector<vector<ll>>(base);
		for (int shift = 0; shift < base; shift++)
		{
			prefix_sums[base][shift] = vector<ll>(elements.size() / base + 1);
			// Compute the prefix sum for base and shift
			prefix_sums[base][shift][0] = elements[shift];
			int prefix_it = 1;
			for (size_t i = base + shift; i < elements.size(); i += base)
			{
				prefix_sums[base][shift][prefix_it] = prefix_sums[base][shift][prefix_it - 1] + elements[i];
				prefix_it++;
			}
		}
	}

	// Answer the queries
	vector<ll> solution(queries.size());
	for (size_t query_no = 0; query_no < queries.size(); query_no++)
	{
		int l = queries[query_no][0];
		int r = queries[query_no][1];
		int k = queries[query_no][2];

		if (k <= max_base)
		{
			int shift = l % k;
			int left_position = l / k;
			int right_position = r / k;
			ll sum = 0;
			if (left_position == 0)
				sum = prefix_sums[k][shift][right_position];
			else
				sum = prefix_sums[k][shift][right_position] - prefix_sums[k][shift][left_position - 1];

			solution[query_no] = sum;
		}
		else
			solution[query_no] = solve_query_bruteforce(elements, l, r, k);
	}
	return solution;
}

int main()
{
	ios::sync_with_stdio(false);
	cin.tie(0);
	int n; cin >> n;
	vector<ll> elements(n);
	for (size_t i = 0; i < n; i++)
		cin >> elements[i];

	int query_count; cin >> query_count;
	vector<vector<ll>> queries = vector<vector<ll>>(query_count, vector<ll>(3));
	for (size_t i = 0; i < query_count; i++)
	{
		for (size_t j = 0; j < 3; j++)
		{
			cin >> queries[i][j];
			if (j != 2)
				queries[i][j]--;
		}
	}
	vector<ll> solution;
	if (false)//n <= 10000)
	{
		solution = bruteforce(elements, queries);
	}
	else
	{
		solution = solve(elements, queries);
	}
	for (size_t i = 0; i < solution.size(); i++)
		cout << solution[i] << "\n";
	
	return 0;
}