#include <bits/stdc++.h>
using namespace std;

#define x first
#define y second
typedef pair<int,int> tacka;
typedef long long ll;

const int maxN = 3e5 + 7;
tacka niz[maxN], P;

int orijentacija(tacka A, tacka B, tacka C) {
    ll p1 = C.x - B.x; p1 *= (B.y - A.y);
    ll p2 = C.y - B.y; p2 *= (B.x - A.x);
    ll p = p1 - p2;
    return (p < 0 ? -1 : p > 0 ? 1 : 0);
}

int seg[2][maxN];

void build(int v, int l, int r) {
    if (l == r) {
        seg[0][v] = seg[1][v] = niz[l].x;
        return;
    }
    int m = (l + r) / 2;
    build(2 * v, l, m);
    build(2 * v + 1, m + 1, r);
}

void query(int v, int l, int r, int L, int R, pair<int,int> &mxn) {
    if (r < L || R < l) {
        return;
    }
    if (L <= l && r <= R) {
        mxn.x = min(mxn.x, seg[0][v]);
        mxn.y = max(mxn.y, seg[1][v]);
        return;
    }
    int m = (l + r) / 2;
    query(2 * v, l, m, L, R, mxn);
    query(2 * v + 1, m + 1, r, L, R, mxn);
}

void Resi(int N, int Px, int Py, int *X, int *Y, int Q, int *L, int *R, bool *O) {
    int n = N;
    for (int i = 1; i <= n; i++) {
        niz[i] = {X[i], Y[i]};
    }
    P = {Px, Py};

    bool yy = true;
    for (int i = 1; i <= n; i++) {
        yy &= (Y[i] == 0);
    }
    if (yy) {
        build(1, 1, n);
        for (int q = 1; q <= Q; q++) {
            pair<int,int> p = {1e9, -1e9};
            query(1, 1, n, L[q], R[q], p);
            O[q] = (Px >= p.x && Px <= p.y);
        }
        return;
    }

    for (int q = 1; q <= Q; q++) {
        O[q] = false;
        for (int i = L[q]; i <= R[q] && !O[q]; i++) {
            if (P == niz[i]) {
                O[q] = true;
                break;
            }
            for (int j = L[q]; j < i && !O[q]; j++) {
                if (orijentacija(niz[i], niz[j], P) == 0) {
                    O[q] = true;
                }
                for (int k = L[q]; k < j && !O[q]; k++) {
                    int o1 = orijentacija(niz[i], niz[j], P);
                    int o2 = orijentacija(niz[j], niz[k], P);
                    int o3 = orijentacija(niz[k], niz[i], P);
                    if (o1 == 0 || o2 == 0 || o3 == 0) {
                        O[q] = true;
                    }
                    if (o1 == o2 && o2 == o3) {
                        O[q] = true;
                    }
                }
            }
        }
    }
}