#include <bits/stdc++.h>

using namespace std;

const int N = 1e5+10;
int a[N];
int stmin[4*N];
int stmax[4*N];

#define int long long

void buildmin(int index, int l, int r)
{
    if(l > r) return;
    if(l == r)
    {
        stmin[index] = a[l];
        return;
    }
    int mid = (l+r)/2;
    buildmin(2*index, l, mid);
    buildmin(2*index+1, mid+1, r);
    stmin[index] = min(stmin[2*index], stmin[2*index+1]);
}

void buildmax(int index, int l, int r)
{
    if(l > r) return;
    if(l == r)
    {
        stmax[index] = a[l];
        return;
    }
    int mid = (l+r)/2;
    buildmax(2*index, l, mid);
    buildmax(2*index+1, mid+1, r);
    stmax[index] = max(stmax[2*index], stmax[2*index+1]);
}

int getmin(int index, int l, int r, int L, int R)
{
    if(l > r) return INT_MAX;
    if(L <= l && r <= R) return stmin[index];
    if(r < L || R < l) return INT_MAX;
    int mid = (l+r)/2;
    return min(getmin(2*index, l, mid, L, R), getmin(2*index+1, mid+1, r, L, R));
}

int getmax(int index, int l, int r, int L, int R)
{
    if(l > r) return -INT_MAX;
    if(L <= l && r <= R) return stmax[index];
    if(r < L || R < l) return -INT_MAX;
    int mid = (l+r)/2;
    return max(getmax(2*index, l, mid, L, R), getmax(2*index+1, mid+1, r, L, R));
}

int vp(int x1, int y1, int x2, int y2, int x, int y)
{
    int X1 = x-x1;
    int Y1 = y-y1;
    int X2 = x2-x1;
    int Y2 = y2-y1;
    return X2*Y1-Y2*X1;
}

bool OK(int x1, int y1, int x2, int y2, int x3, int y3, int x, int y)
{
    int a = vp(x1, y1, x2, y2, x, y);
    int b = vp(x2, y2, x3, y3, x, y);
    int c = vp(x3, y3, x1, y1, x, y);
    if(!a) return x1 <= x && x <= x2 || x2 <= x && x <= x1;
    if(!b) return x2 <= x && x <= x3 || x3 <= x && x <= x2;
    if(!c) return x3 <= x && x <= x1 || x1 <= x && x <= x3;
    return a < 0 && b < 0 && c < 0 || a > 0 && b > 0 && c > 0;
}

void PST(int n, int px, int py, int *x, int *y, int q, int *l, int *r, bool *o)
{
    for(int query = 1; query <= q; query++)
    {
        bool ok = false;
        for(int i = l[query]; i <= r[query]; i++)
        {
            for(int j = i+1; j <= r[query]; j++)
            {
                for(int k = j+1; k <= r[query]; k++)
                {
                    if(OK(x[i], y[i], x[j], y[j], x[k], y[k], px, py))
                    {
                        ok = true;
                        break;
                    }
                }
            }
        }
        o[query] = ok;
    }
}

void TST(int n, int px, int py, int *x, int *y, int q, int *l, int *r, bool *o)
{
    for(int i = 1; i <= n; i++)
        a[i] = x[i];
    buildmin(1, 1, n);
    buildmax(1, 1, n);
    for(int i = 1; i <= q; i++)
        o[i] = (getmin(1, 1, n, l[i], r[i]) <= px && px <= getmax(1, 1, n, l[i], r[i]));
}

void Resi(int n, int px, int py, int *x, int *y, int q, int *l, int *r, bool *o)
{
    if(n <= 100 && q <= 100) PST(n, px, py, x, y, q, l, r, o);
    bool tst = true;
    if(py != 0) tst = false;
    for(int i = 1; i <= n; i++)
        if(y[i] != 0) tst = false;
    if(tst) TST(n, px, py, x, y, q, l, r, o);
}