#include <bits/stdc++.h>
using namespace std;

using ll = long long;

const int MAXN = 300000;

struct Point{
    ll x, y;
    ll operator *(const Point &a){
        return y*a.x - x*a.y;
    }
    Point operator -(const Point &a){
        ll nx = x - a.x;
        ll ny = y - a.x;
        Point g;
        g.x = nx;
        g.y = ny;
        return g;
    }
    Point neg(){
        Point g;
        g.x = -x;
        g.y = -y;
        return g;
    }
} P[MAXN];

Point makepoint(ll x, ll y){
    Point ff;
    ff.x = x;
    ff.y = y;
    return ff;
}

bool cmp(Point A, Point B){
    if(A.x == B.x) return A.y > B.y;
    return A.x < B.x;
}

int mxprava[MAXN][20];
int mxtacka[MAXN][20];
int trig[MAXN];

const int D = 4;

bool kv0(int x, int y){
    return x >= 0 && y >= 0;
}

bool kv1(int x, int y){
    return x <= 0 && y >= 0;
}

bool kv2(int x, int y){
    return x <= 0 && y <= 0;
}

bool kv3(int x, int y){
    return x >= 0 && y <= 0;
}

int kvadranti(int x, int y){
    int rs = 0;
    if(x >= 0 && y >= 0) rs += 1;
    if(x <= 0 && y >= 0) rs += 2;
    if(x <= 0 && y <= 0) rs += 4;
    if(x >= 0 && y <= 0) rs += 8;
    return rs;
}

vector <pair <Point, int>> k0, k1, k2, k3;

int seg[4][8*MAXN+5];

void upd(int idx, int node, int l, int r, int x, int val){
    if(l == r){
        seg[idx][node] = val;
        return;
    }
    int mid = (l+r)/2;
    if(x <= mid) upd(idx, node*2, l, mid, x, val);
    else upd(idx, node*2+1, mid+1, r, x, val);
    seg[idx][node] = max(seg[idx][node*2], seg[idx][node*2+1]);
}

int getmax(int idx, int node, int l, int r, int tl, int tr){
    if(tl > r || l > tr) return 0;
    if(tl <= l && r <= tr) return seg[idx][node];
    int mid = (l+r)/2;
    return max(getmax(idx, node*2, l, mid, tl, tr), getmax(idx, node*2+1, mid+1, r, tl, tr));
}

int poz[4][MAXN+5];

bool prava(Point a, Point b){
    return a*b == 0;
}

bool pravi(Point a, Point b, Point c){
    return prava(a, b) || prava(a, c) || prava(b, c) || (a*b > 0 && b*c > 0 && c*a > 0) || (a*b < 0 && b*c < 0 && c*a < 0);
}

bool polare(pair <Point, int> a, pair <Point, int> b){
    return b.first*a.first > 0;
}

int sz[4];

void Resi(int N, int Px, int Py, int *X, int *Y, int Q, int *L, int *R, bool *O){
    if(N > 200) return;
    for(int i=1; i<=N; i++){
        X[i] -= Px;
        Y[i] -= Py;
        P[i] = makepoint(X[i], Y[i]);
        //cout << X[i] << " " << Y[i] << "\n";
        if(kv0(X[i], Y[i])){
            k0.push_back({P[i], i});
            k2.push_back({P[i].neg(), i});
        }
        if(kv1(X[i], Y[i])){
            k1.push_back({P[i], i});
            k3.push_back({P[i].neg(), i});
        }
        if(kv2(X[i], Y[i])){
            k2.push_back({P[i], i});
            k0.push_back({P[i].neg(), i});
        }
        if(kv3(X[i], Y[i])){
            k3.push_back({P[i], i});
            k1.push_back({P[i].neg(), i});
        }
    }
    sort(k0.begin(), k0.end(), polare);
    sort(k1.begin(), k1.end(), polare);
    sort(k2.begin(), k2.end(), polare);
    sort(k3.begin(), k3.end(), polare);
    for(int i=0; i<int(k0.size()); i++){
        if(!i || !prava(k0[i].first, k0[i-1].first)) sz[0]++;
        poz[0][k0[i].second] = sz[0];
    }
    for(int i=0; i<int(k1.size()); i++){
        if(!i || !prava(k1[i].first, k1[i-1].first)) sz[1]++;
        poz[1][k1[i].second] = sz[1];
    }
    for(int i=0; i<int(k2.size()); i++){
        if(!i || !prava(k2[i].first, k2[i-1].first)) sz[2]++;
        poz[2][k2[i].second] = sz[2];
    }
    for(int i=0; i<int(k3.size()); i++){
        if(!i || !prava(k3[i].first, k3[i-1].first)) sz[3]++;
        poz[3][k3[i].second] = sz[3];
    }
    for(int i=1; i<=N; i++){
        for(int j=0; j<(1<<D); j++){
            mxprava[i][j] = mxprava[i-1][j];
            mxtacka[i][j] = mxtacka[i-1][j];
        }
        trig[i] = trig[i-1];
        int h = kvadranti(X[i], Y[i]);
        for(int j=0; j<=h; j++){
            if((j & h) == j) mxtacka[i][j] = i;
        }
        for(int j=i-1; j>=1; j--){
            if(prava(P[i], P[j])){
                trig[i] = max(trig[i], j);
            }
            for(int k=j-1; k>=1; k--){
                if(pravi(P[i], P[j], P[k])) trig[i] = max(trig[i], k);
            }
        }
        //cout << trig[i] << "Xd" << endl;
        /*for(int j=i-1; j>=1; j--){
            if(kv0(X[i], Y[i])){
                if(!kv2(X[j], X[j])) continue;
                for(int g=j-1; g>=1; g++){

                }
            }
            if(kv1(X[i], Y[i])){

            }
            if(kv2(X[i], Y[i])){

            }
            if(kv3(X[i], Y[i])){

            }
        }*/
        if(kv0(X[i], Y[i])){
            upd(0, 1, 1, 2*MAXN, poz[0][i], i);
        }
        if(kv1(X[i], Y[i])){
            upd(1, 1, 1, 2*MAXN, poz[1][i], i);
        }
        if(kv2(X[i], Y[i])){
            upd(2, 1, 1, 2*MAXN, poz[2][i], i);
        }
        if(kv3(X[i], Y[i])){
            upd(3, 1, 1, 2*MAXN, poz[3][i], i);
        }
        if(kv0(X[i], Y[i])){
            trig[i] = max(trig[i], min(getmax(2, 1, 1, 2*MAXN, 1, poz[2][i]), getmax(2, 1, 1, 2*MAXN, poz[2][i], 2*MAXN)));
        }
        if(kv1(X[i], Y[i])){
            trig[i] = max(trig[i], min(getmax(3, 1, 1, 2*MAXN, 1, poz[3][i]), getmax(3, 1, 1, 2*MAXN, poz[3][i], 2*MAXN)));
        }
        if(kv2(X[i], Y[i])){
            trig[i] = max(trig[i], min(getmax(0, 1, 1, 2*MAXN, 1, poz[0][i]), getmax(0, 1, 1, 2*MAXN, poz[0][i], 2*MAXN)));
        }
        if(kv3(X[i], Y[i])){
            trig[i] = max(trig[i], min(getmax(1, 1, 1, 2*MAXN, 1, poz[1][i]), getmax(1, 1, 1, 2*MAXN, poz[1][i], 2*MAXN)));
        }
    }
    for(int query=1; query<=Q; query++){
        O[query] = 0;
        int l = L[query];
        int r = R[query];
        /*if(mxprava[r][(1<<D)-1] >= l){
            O[query] = 1;
            continue;
        }*/
        if(mxtacka[r][(1<<D)-1] >= l){
            O[query] = 1;
            continue;
        }
        if(trig[r] >= l) O[query] = 1;
        /*for(int i=0; i<D; i++){
            if(mxtacka[r][i] < l) continue;
            if(mxprava[r][((1<<D)-1)^(1<<i)] < l) continue;
            if(mali[r][i] < l) continue;
            if(trig[r] < l) continue;
            O[query] = 1;
            break;
        }*/
    }
}