#include <cstring>
#include <bitset>
#include <algorithm>

#define MAX_N 100
#define MAX_N1 (MAX_N + 1)

struct Road
{
    int target;
    int prot;
};

struct City
{
    int carProt;
    int roadCount;
    Road roads[MAX_N1];
};

City cities[MAX_N1];
bool mask[MAX_N1];

int N1;
int currCity;

void Or(int targetCity, int carProt)
{
    mask[targetCity] = 1;

    for (int i = 1; i <= cities[targetCity].roadCount; ++i)
    {
        carProt = std::max(cities[targetCity].carProt, carProt);
        int next = cities[targetCity].roads[i].target;
            if (mask[next] == 0 && carProt >= cities[targetCity].roads[i].prot)
                Or(next, carProt);
    }
}

void PrintMap()
{
    for (int i = 1; i < N1; ++i)
    {
        printf("City %i: ", i);
        for (int j = 1; j <= cities[i].roadCount; ++j)
        {
            printf("(%i, %i), ", cities[i].roads[j].target, cities[i].roads[j].prot);
        }
        putchar('\n');
    }
    putchar('\n');
}

void Resi(int N, int *A, int M, int *U, int *V, int *W, int *R)
{
    N1 = N + 1;

    for (int i = 1; i < N1; ++i)
        cities[i].carProt = A[i];

    for (size_t i = 1; i <= M; ++i)
    {
        int a = U[i];
        int b = V[i];

        cities[a].roads[cities[a].roadCount + 1] = { b, W[i] };
        cities[b].roads[cities[b].roadCount + 1] = { a, W[i] };

        ++cities[a].roadCount;
        ++cities[b].roadCount;
    }

    for (size_t i = 1; i < N1; ++i)
    {
        memset(mask, 0, N1);
        mask[i] = 1;
        currCity = i;

        for (size_t j = 1; j <= cities[i].roadCount; ++j)
            if (cities[i].carProt >= cities[i].roads[j].prot)
                Or(cities[i].roads[j].target, cities[i].carProt);

        R[i] = std::count(mask + 1, mask + MAX_N1, 1);
    }



    //PrintMap();
}