#include <stdio.h>
#include <bits/stdc++.h>
using namespace std;

struct Node{
    int mini;
    int maxi;
    Node(int x, int y) : mini(x), maxi(y){}
    Node(){Node(0, 0);}
};

const int MAXN = 300005;

pair<int, int> coords[MAXN];
pair<int, int> query[MAXN];
int n;

Node st[4 * MAXN];

void build(int id = 0, int l = 0, int r = n - 1){
    if(l == r){
        st[id].maxi = st[id].mini = coords[l].first;
        return;
    }

    int mid = (l + r) / 2;
    build(id * 2 + 1, l, mid);
    build(id * 2 + 2, mid + 1, r);
    st[id].maxi = max(st[id * 2 + 1].maxi, st[id * 2 + 2].maxi);
    st[id].mini = min(st[id * 2 + 1].mini, st[id * 2 + 2].mini);
}

Node get(int x, int y, int id, int l, int r){
    if(x > r || y < l){
        return Node(INT_MAX, INT_MIN);
    }
    if(x <= l && r <= y){
        return st[id];
    }
    int mid = (l + r) / 2;
    Node v1 = get(x, y, id * 2 + 1, l, mid);
    Node v2 = get(x, y, id * 2 + 2, mid + 1, r);
    Node v3(min(v1.mini, v2.mini), max(v1.maxi, v2.maxi));
    return v3;
}

void solve3(int Q, int Px, bool* O){
    build();

    for(int i = 0; i < Q; ++i){
        Node v = get(query[i].first, query[i].second, 0, 0, n - 1);
        if(v.mini <= Px && Px <= v.maxi)
            O[i + 1] = true;
        else
            O[i + 1] = false;
    }
}

void Resi(int N, int Px, int Py, int *X, int *Y, int Q, int *L, int *R, bool *O){
    bool y0 = true;
    n = N;
    for(int i = 1; i <= n; ++i){
        coords[i - 1] = {X[i], Y[i]};
        if(Y[i] != 0)
            y0 = false;
    }
    for(int i = 1; i <= Q; ++i){
        query[i - 1] = {L[i] - 1, R[i] - 1};
    }

    if(y0){
        solve3(Q, Px, O);
    }
}

/*
5 4 0
0 1
3 0
2 0
5 0
0 0
7
1 2
1 3
1 4
1 5
2 3
4 5
3 5
----
Ne
Ne
Da
Da
Ne
Da
Da
*/