#include <stdio.h>
#include <bits/stdc++.h>
using namespace std;

struct Node{
    int mini;
    int maxi;
    Node(int x, int y) : mini(x), maxi(y){}
    Node(){Node(0, 0);}
};

const int MAXN = 300005;

pair<int, int> coords[MAXN];
pair<int, int> query[MAXN];
int n;

Node st[4 * MAXN];

void build(int id = 0, int l = 0, int r = n - 1){
    if(l == r){
        st[id].maxi = st[id].mini = coords[l].first;
        return;
    }

    int mid = (l + r) / 2;
    build(id * 2 + 1, l, mid);
    build(id * 2 + 2, mid + 1, r);
    st[id].maxi = max(st[id * 2 + 1].maxi, st[id * 2 + 2].maxi);
    st[id].mini = min(st[id * 2 + 1].mini, st[id * 2 + 2].mini);
}

Node get(int x, int y, int id, int l, int r){
    if(x > r || y < l){
        return Node(INT_MAX, INT_MIN);
    }
    if(x <= l && r <= y){
        return st[id];
    }
    int mid = (l + r) / 2;
    Node v1 = get(x, y, id * 2 + 1, l, mid);
    Node v2 = get(x, y, id * 2 + 2, mid + 1, r);
    Node v3(min(v1.mini, v2.mini), max(v1.maxi, v2.maxi));
    return v3;
}

void solve3(int Q, int Px, bool* O){
    build();

    for(int i = 0; i < Q; ++i){
        Node v = get(query[i].first, query[i].second, 0, 0, n - 1);
        if(v.mini <= Px && Px <= v.maxi)
            O[i + 1] = true;
        else
            O[i + 1] = false;
    }
}

pair<int, int> getVec(int x1, int y1, int x2, int y2){
    return {x2 - x1, y2 - y1};
}

int orientation(int x1, int y1, int x2, int y2){ //takes 2 vecs
    return x2*y1 - x1*y2;
}

int normo(int x){
    if(x == 0)
        return 0;
    if(x < 0)
        return -1;
    return 1;
}

bool pointInTriangle(int* x, int* y, int px, int py){
    //check on same point
    for(int i = 0; i < 3; ++i){
        if(x[i] == px && y[i] == py){
            return true;
        }
    }

    //check on same line
    int vx[] = {x[1] - x[0], x[2] - x[1], x[0] - x[2]};
    int vy[] = {y[1] - y[0], y[2] - y[1], y[0] - y[2]};

    int ori[3];
    for(int i = 0; i < 3; ++i){
        ori[i] = orientation(vx[i], vy[i], px - x[(i + 1) % 3], py - y[(i + 1) % 3]);
        bool naDuzi = (min(x[i], x[(i + 1) % 3]) <= px && px <= max(x[i], x[(i + 1) % 3])) && (min(y[i], y[(i + 1) % 3]) <= py && py <= max(y[i], y[(i + 1) % 3]));
        if(ori[i] == 0 && naDuzi){
            return true;
        }
    }

    bool ff = true;
    for(int i = 0; i < 3; ++i){
        if(normo(ori[i]) != normo(ori[(i + 1) % 3])){
            ff = false;
            break;
        }
    }

    return ff;
}

void solve1(int px, int py, int q, bool* O){
    for(int t = 0; t < q; ++t){
        int l = query[t].first;
        int r = query[t].second;
        bool found = false;
        for(int i = l; i <= r; ++i){
            for(int j = l; j < i; ++j){
                for(int k = l; k < j; ++k){
                    //take triangle i, j, k and check if P is in it

                    int x[] = {coords[i].first, coords[j].first, coords[k].first};
                    int y[] = {coords[i].second, coords[j].second, coords[k].second};

                    found |= pointInTriangle(x, y, px, py);
                    if(found)
                        break;
                }
                if(found)
                    break;
            }
            if(found)
                break;
        }
        O[t + 1] = found;
    }
}

void Resi(int N, int Px, int Py, int *X, int *Y, int Q, int *L, int *R, bool *O){
    bool y0 = true;
    n = N;
    for(int i = 1; i <= n; ++i){
        coords[i - 1] = {X[i], Y[i]};
        if(Y[i] != 0)
            y0 = false;
    }
    for(int i = 1; i <= Q; ++i){
        query[i - 1] = {L[i] - 1, R[i] - 1};
    }

    if(y0){
        solve3(Q, Px, O);
    }else{
        solve1(Px, Py, Q, O);
    }
}


/*
int main(){
	int N, Px, Py;
	scanf("%i %i %i", &N, &Px, &Py);

	int *X = new int[N+1], *Y = new int[N+1];
	for(int i = 1; i <= N; i++){
		scanf("%i %i", &X[i], &Y[i]);
	}

	int Q;
	scanf("%i", &Q);

	int *L = new int[Q+1], *R = new int[Q+1];
	for(int i = 1; i <= Q; i++){
		scanf("%i %i", &L[i], &R[i]);
	}

	bool *O = new bool[Q+1];

	Resi(N, Px, Py, X, Y, Q, L, R, O);

	for(int i = 1; i <= Q; i++){
		if(O[i]){
			printf("Da\n");
		}else{
			printf("Ne\n");
		}
	}

	delete[] X;
	delete[] Y;
	delete[] L;
	delete[] R;
	delete[] O;

	return 0;
}

*/

/*
5 4 0
0 1
3 0
2 0
5 0
0 0
7
1 2
1 3
1 4
1 5
2 3
4 5
3 5
----
Ne
Ne
Da
Da
Ne
Da
Da
*/