#include <bits/stdc++.h>

using namespace std;

typedef long long ll;
typedef vector<int> vi;
typedef vector<ll> vl;
typedef pair<int, int> pi;
typedef vector<pi> vp;

template<int maxn>
struct segtree{
    struct node{
        int x, y;

        node(int x = INT32_MIN, int y = INT32_MAX) : x(x), y(y) {}

        node& operator+=(const node& other){
            x = max(x, other.x);
            y = min(y, other.y);
            return *this;
        }

        node operator+(const node& other){
            node tmp = *this;
            return tmp += other;
        }
    };

    node a[2*maxn];

    void init(vi t){
        for (int i = 0; i < 2 * maxn; ++i){
            a[i] = node{};
        }

        for (int i = 0; i < t.size(); ++i){
            a[i+maxn] = {t[i],t[i]};
        }


        for (int i = maxn-1; i > 0; --i){
            a[i] = a[2*i] + a[2*i+1];
        }
    }

    node get(int l, int r, int pos = 1, int L = 1, int R = maxn){
        if (l <= L && R <= r){
            return a[pos];
        }

        if (r < L || R < l) return node{};

        int mid = (L+R)/2;
        return get(l,r,2*pos,L,mid) + get(l,r,2*pos+1,mid+1,R);
    }

};
segtree<131072*2> drvo;

void Resi(int N, int Px, int Py, int *X, int *Y, int Q, int *L, int *R, bool *O){

    bool ok3=(Py == 0);
    for (int i = 1; i <= N; ++i){
        if (Y[i]!= 0)
            ok3=0;
    }

    if (ok3){
        vi a;
        for (int i = 1; i <= N; ++i){
            a.push_back(X[i]);
        }
        drvo.init(a);

        for (int i = 1; i <= Q; ++i){
            auto k = drvo.get(L[i], R[i]);
            cout << k.x << ' ' << k.y << '\n';

            if (k.x >= Px && k.y <= Px){
                O[i] = 1;
            } else {
                O[i] = 0;
            }
        }
    } else throw SIGSEGV;
}