#include <bits/stdc++.h>

using namespace std;

typedef long long ll;
typedef vector<int> vi;
typedef vector<ll> vl;
typedef pair<int, int> pi;
typedef vector<pi> vp;

template<int maxn>
struct segtree{
    struct node{
        int x, y;

        node(int x = INT32_MIN, int y = INT32_MAX) : x(x), y(y) {}

        node& operator+=(const node& other){
            x = max(x, other.x);
            y = min(y, other.y);
            return *this;
        }

        node operator+(const node& other){
            node tmp = *this;
            return tmp += other;
        }
    };

    node a[2*maxn];

    void init(vi t){
        for (int i = 0; i < 2 * maxn; ++i){
            a[i] = node{};
        }

        for (int i = 0; i < t.size(); ++i){
            a[i+maxn] = {t[i],t[i]};
        }


        for (int i = maxn-1; i > 0; --i){
            a[i] = a[2*i] + a[2*i+1];
        }
    }

    node get(int l, int r, int pos = 1, int L = 1, int R = maxn){
        if (l <= L && R <= r){
            return a[pos];
        }

        if (r < L || R < l) return node{};

        int mid = (L+R)/2;
        return get(l,r,2*pos,L,mid) + get(l,r,2*pos+1,mid+1,R);
    }

};
segtree<131072*2> drvo;

double dist(int x1, int y1, int x2, int y2){
    double d1 = x1-x2, d2=y1-y2;

    return sqrt(d1*d1+d2*d2);
}

int povrs(int x1, int y1, int x2, int y2, int x3, int y3){
    double a =dist(x1,y1,x2,y2);
    double b =dist(x3,y3,x2,y2);
    double c =dist(x1,y1,x3,y3);

    double s = (a+b+c)/3.0;

    double p = sqrt(s * (s-a) * (s-b) * (s-c));
    return p;
}

void Resi(int N, int Px, int Py, int *X, int *Y, int Q, int *L, int *R, bool *O){

    int px = Px;
    int py = Py;
    bool ok3=(Py == 0);
    for (int i = 1; i <= N; ++i){
        if (Y[i]!= 0)
            ok3=0;
    }

    if (ok3){
        vi a;
        for (int i = 1; i <= N; ++i){
            a.push_back(X[i]);
        }
        drvo.init(a);

        for (int i = 1; i <= Q; ++i){
            auto k = drvo.get(L[i], R[i]);

            if (k.x >= Px && k.y <= Px){
                O[i] = 1;
            } else {
                O[i] = 0;
            }
        }
    } else {
        bool ok = 0;
        for (int i = 1; i <= Q; ++i){
            for (int i1 = L[i]; i1 <= R[i]; ++i1){
                for (int i2 = i1+1; i2 <= R[i]; ++i2){
                    for (int i3 = i2 + 1; i3 <= R[i]; ++i3){
                        if (povrs(X[i1], Y[i1], X[i2], Y[i2], X[i3], Y[i3]) == povrs(X[i1], Y[i1], X[i2], Y[i2], px, py) + povrs(X[i1], Y[i1], px, py, X[i3], Y[i3]) + povrs(px, py, X[i2], Y[i2], X[i3], Y[i3]))
                        ok = 1;
                    }
                }
            }

            for (int i1 = L[i]; i1 <= R[i]; ++i1){
                for (int i2 = i1 + 1; i2 <= R[i]; ++i2){
                    if (dist(px,py,X[i1],Y[i1]) + dist(px,py,X[i2],Y[i2]) == dist(X[i1],Y[i1],X[i2],Y[i2]))
                        ok = 1;
                }
            }

            for (int j = L[i]; j <= R[i]; ++j)
                if (px == X[j] && py == Y[j])
                    ok=1;

            if (ok)
                O[i]=1;
            else
                O[i]=0;
        }


    }
}