#include <bits/stdc++.h>

#define pb push_back
#define ll long long
#define vec pair<ll, ll>
#define x first
#define y second

using namespace std;

ll operator^(vec a, vec b) {
    return a.x * b.y - a.y * b.x;
}

ll operator*(vec a, vec b) {
    return a.x * a.y + b.x * b.y;
}

vec operator-(vec a, vec b) {
    return {a.x - b.x, a.y - b.y};
}

int side(vec a, vec b, vec p) {

	ll cross = (b - a) ^ (p - a);
	if(cross == 0)
		return 0;
	if(cross > 0)
		return 1;
	return -1;
}

vector< vec > convexHull(vec x[], int n, int l, int r) {

    vec arr[n];
    for(int i = 0; i < n; i++)
        arr[i] = x[i];
	sort(arr + l, arr + r + 1);
	vector< vec > up;
	up.pb(arr[l]);
	up.pb(arr[l + 1]);
	int k = 2;
	for(int i = l + 2; i <= r; i++) {
		while(k > 1 && side(up[k - 2], up[k - 1], arr[i]) != -1) {
			up.pop_back();
			k--;
		}
		up.pb(arr[i]);
        k++;
	}

	vector< vec > down;
	down.pb(arr[l]);
	down.pb(arr[l + 1]);
	k = 2;
	for(int i = l + 2; i <= r; i++) {
		while(k > 1 && side(down[k - 2], down[k - 1], arr[i]) != 1) {
			down.pop_back();
			k--;
		}
		down.pb(arr[i]);
        k++;
	}

	vector< vec > hull;
	for(int i = 0; i < down.size(); i++)
		hull.pb(down[i]);
	for(int i = up.size() - 2; i > 0; i--)
		hull.pb(up[i]);
    
    return hull;
}

bool onSegment(vec a, vec b, vec p) {

	return ((p - a) * (p - b)) <= 0;
}

void Resi(int N, int Px, int Py, int *X, int *Y, int Q, int *L, int *R, bool *O) {

	vec p((ll)Px, (ll)Py);
	vec arr[N];
	for(int i = 0; i < N; i++)
		arr[i] = vec((ll)X[i + 1], (ll)Y[i + 1]);
	for(int i = 1; i <= Q; i++) {
		int l = L[i], r = R[i];
		l--; r--;
		if(l == r) {
			O[i] = (p == arr[l]);
			continue;
        }
        O[i] = true;
		vector< vec > c = convexHull(arr, N, l, r);
		for(int j = 0; j < c.size(); j++) {
			int s = side(c[j], c[(j + 1) % c.size()], p);
			if(s == 1)
				continue;
			if(s == -1) {
				O[i] = false;
				break;
			}
			O[i] = onSegment(c[j], c[j + 1], p);
			break;
		}
	}
}