#include <stdio.h>
#include <bits/stdc++.h>
using namespace std;
using ll = int64_t;

vector<vector<pair<int, int>>> g;

void dfs1(int s, vector<bool>& seen, int a1, vector<int>& gr, int rgr, vector<int>& grsz){
    seen[s] = true;
    gr[s] = rgr;
    grsz[rgr]++;
    for(pair<int, int> p : g[s]){
        int e = p.first;
        int w = p.second;
        if(!seen[e] && w <= a1){
            dfs1(e, seen, a1, gr, rgr, grsz);
        }
    }
}

void solve1(int N, int* R, int al){
    vector<int> gr(N+1);
    vector<int> grsz(N+1);
    int rgr = 1;

    int ret = 0;
    vector<bool> seen(N+1);
    for(int i=1; i<=N; ++i){
        if(!seen[i]){
            dfs1(i, seen, al, gr, rgr, grsz);
            rgr++;
        }
    }

    for(int i=1; i<=N; ++i){
        R[i] = grsz[gr[i]];
    }
}

struct edge{
    int u, v;
    int w;
    edge(){}
    edge(int _u, int _v, int _w){
        u = _u, v = _v, w = _w;
    }
};

bool compw(edge a, edge b){
    return a.w < b.w;
}

int cntreach(int x, int N){
    vector<bool> seen(N+1, false);
    return 1;
}

void dfs2(int s, vector<bool>& seen, vector<int>& gr, int rgr, vector<int>& grsz){
    seen[s] = true;
    gr[s] = rgr;
    grsz[rgr]++;
    for(pair<int, int> p : g[s]){
        int e = p.first;
        int w = p.second;
        if(!seen[e]){
            dfs2(e, seen, gr, rgr, grsz);
        }
    }
}

void solve2(int N, int* R, int* A, int w){
    vector<int> gr(N+1);
    vector<int> grsz(N+1);
    int rgr = 1;

    int ret = 0;
    vector<bool> seen(N+1);
    for(int i=1; i<=N; ++i){
        if(!seen[i]){
            dfs2(i, seen, gr, rgr, grsz);
            rgr++;
        }
    }

    for(int i=1; i<=N; ++i){
        R[i] = (A[i] >= w ? grsz[gr[i]] : 1);
    }
}

/*
5 5
5 9 6 1 3
1 5 7
1 2 4
2 5 9
4 3 2
3 5 6
*/

int djakstrafrom(int N, int x, int* A){
    int ret = 0;
    int mxA = 0;

    vector<bool> seen(N+1, false);
    priority_queue<pair<int, int>> pq;
    pq.push({0, x});

    while(!pq.empty()){
        auto p = pq.top();
        pq.pop();
        int s = p.second;
        int w = -p.first;
        if(seen[s]) continue;
        seen[s] = true;
        ret++;

        mxA = max(mxA, A[s]);

        for(pair<int, int> pp : g[s]){
            int v = pp.first;
            int wv = pp.second;
            if(!seen[v] && wv <= mxA) pq.push({-wv, v});
        }
    }

    return ret;
}

void solve4(int N, int* R, int* A){
    for(int i=1; i<=N; ++i){
        R[i] = djakstrafrom(N, i, A);
    }
}

void Resi(int N, int *A, int M, int *U, int *V, int *W, int *R){
    vector<edge> edges(M+1);
    for(int i=1; i<=M; ++i){
        edges[i] = edge(U[i], V[i], W[i]);
    }
    sort(edges.begin()+1, edges.end(), compw);

    g.resize(N+1);
    for(int i=1; i<=M; ++i){
        int u = U[i];
        int v = V[i];
        int w = W[i];
        g[v].push_back({u, w});
        g[u].push_back({v, w});
    }
    bool as = true;
    int ai = A[1];
    for(int i=1; i<=N; ++i){
        as = as && A[i]==ai;
    }

    int wi = edges[1].w;
    bool ws = true;
    for(int i=1; i<=M; ++i){
        ws = ws && edges[i].w == wi;
    }

    if(ws) solve2(N, R, A, edges[1].w);
    if(as) solve1(N, R, A[1]);
    else solve4(N, R, A);
}