#include <bits/stdc++.h>

using namespace std;

typedef long long ll;

const int mxN = 3e5 + 5;
const int mod = 1e9+7;

ll powb(ll a, ll x)
{
    ll ret = 1;
    a %= mod;
    while(x)
    {
        if(x&1) ret=ret*a%mod;
        x>>=1;
        a=a*a%mod;
    }
    return ret;
}

ll inv(ll a)
{
    return powb(a, mod-2);
}

mt19937 mt_rand(chrono::high_resolution_clock::now().time_since_epoch().count());

struct treap
{
    treap *left, *right;
    int w, size, v;
    treap(int vv)
    {
        v = vv;
        w = mt_rand();
        size = 1;
        left = right = NULL;
    }
};

int size(treap* t)
{
    return t?t->size:0;
}

void split(treap *t, treap* &left, treap*& right, int k)
{
    if(t == NULL)
    {
        left = right = NULL;
    }
    else
    {
        if(size(t->left) < k)
        {
            split(t->right, t->right, right, k-size(t->left)-1);
            left = t;
        }
        else
        {
            split(t->left, left, t->left, k);
            right = t;
        }
        t->size = size(t->left)+size(t->right)+1;
    }
}

void merge(treap *& t, treap* left, treap* right)
{
    if(left == NULL) t = right;
    else if(right == NULL) t = left;
    else
    {
        if(left->w < right->w)
        {
            merge(left->right, left->right, right);
            t = left;
        }
        else
        {
            merge(right-> left, left, right-> left);
            t = right;
        }
        t->size = size(t->left)+size(t->right)+1;
    }
}

int ft[mxN];
void add(int k, int v)
{
    while(k < mxN)
    {
        ft[k] += v;
        k += k&-k;
    }
}
int sum(int k)
{
    int ans = 0;
    while(k)
    {
        ans += ft[k];
        k -= k&-k;
    }
    return ans;
}

//centroid decomp => find ceontroid, dfs, iscentorid, init_centroid
//lca
//dp 2x2
//binary po resenju
//sortiranje greedy
//combinacije
//(a b) = a!/b!(a-b)!
//li chao tree
//line container CHT multiset, bad, intersection point =
/*
k == l.k return n > l.n 1e18 : -1e18;
(double)(n - l.n) / (l.k - k); /// k slope, n add
*/
//hash = E(a[i]*p^i)
//binary lift
//dp[n][k]
//isomorphism
//empty string sa dp
//digit dp
//dijkstra
//bellman negative cycle
//uzmi sve observacije
//probaj subtask do full resenja
//monotonic stack i min range sum
//bridgeovi, artikularni cvorovi
//random heuristic
//segment tree
//dnq levo desno middle
//pizzeria queires
//investigation dp na tree
//decomp grafa na tree
//decomp tree na segment tree
//euler circuit i path
//tortoise i hare
//josephus
//coprime pairs i dp
//matrix mul i j k, p[i][k] = ij * jk
//expected value = suma za svaku expected
//ide gas

struct segmentTree
{
    vector<int> val;

};

struct DSU
{
    vector<int> size, p, ans, A;
    void build(int n, int* AA)
    {
        size = vector<int>(n, 1);
        p = vector<int>(n);
        iota(p.begin(), p.end(), 0);
        ans = vector<int>(n, -1);
        A = vector<int>(n);
        for(int i = 0; i < n; i++)
        {
            A[i] = AA[i+1];
        }
    }
    int get(int x)
    {
        if(x!=p[x]) return get(p[x]); ///bez path comp
        return x;
    }
    bool unite(int a, int b)
    {
        a = get(a), b = get(b);
        if(a == b) return false;
        if(size[a] > size[b]) swap(a, b);
        p[a] = b;
        size[b] += size[a];
        A[b] = max(A[b], A[a]);
        return true;
    }
    int answer(int i)
    {
        if(ans[i] != -1)
        {
            return ans[i];
        }
        if(i == p[i])
        {
            return size[i];
        }
        while(ans[i] == -1 && i != p[i])
        {
            i = p[i];
        }
        if(i == p[i])
        {
            return size[i];
        }
        if(ans[i] != -1)
        {
            return ans[i];
        }
    }
};

struct edge
{
    int u, v, w;
    bool operator<(const edge& e) const
    {
        return w < e.w;
    }
};

edge edges[mxN];
vector<edge> actual;
vector<int> adj[mxN];
//int parent[mxN];


map<int, vector<edge>> ed;

void Resi(int N, int *A, int M, int *U, int *V, int *W, int *R)
{
    for(int i = 0; i < M; i++)
    {
        edges[i] = {U[i+1]-1, V[i+1]-1, W[i+1]};
    }
    sort(edges, edges+M);
    DSU dsu;
    dsu.build(N, A);
    for(int i = 0; i < M; i++)
    {
        if(dsu.unite(edges[i].u, edges[i].v))
        {
            actual.push_back(edges[i]);
            //cout << "ok " << actual.back().u << " " << actual.back().v << " " << actual.back().w << "\n";
            ed[edges[i].w].push_back(edges[i]);
        }
    }
    DSU ans; ans.build(N, A); ///check spellin

    for(auto& par : ed)
    {
        vector<edge> edg = par.second;
        for(edge e : edg)
        {
            int u = ans.get(e.u), v = ans.get(e.v);
            if(e.w > ans.A[u])
            {
                ans.ans[u] = ans.size[u];
                //cout << "set ans " << u << " " << ans.size[u] << "\n";
            }
            if(e.w > ans.A[v])
            {
                ans.ans[v] = ans.size[v];
                //cout << "set ans " << u << " " << ans.size[u] << "\n";
            }
        }
        for(edge e : edg)
        {
            int u = ans.get(e.u), v = ans.get(e.v);
            if(e.w <= ans.A[u] || e.w <= ans.A[v])
            {
                ans.unite(u, v);
            }
        }
    }
    for(int i = 0; i < N; i++)
    {
        R[i+1] = ans.answer(i);
    }
}


///big floppa carry