#include <algorithm>
#include <iostream>
#include <queue>
#include <vector>
using namespace std;
typedef long long ll;
template<typename T> void print_vec(const vector<vector<T>>& v)
{
    for(auto row: v)
    {
        for(auto col: row)
            cout << col << " ";
        cout << "\n";
    }
    cout << "\n";
}
template<typename T> void print_vec(const vector<T>& v)
{
    for(auto col: v)
        cout << col << " ";
    cout << "\n";
}

void explore_node(int node, const vector<vector<int>>& graph,const vector<vector<ll>>& weights, priority_queue<pair<ll,int>, vector<pair<ll,int>>, greater<pair<ll,int>>>& unexplored_edges)
{
    for(int i = 0; i < graph[node].size(); i++)
    {
        unexplored_edges.push({weights[node][i],graph[node][i]});
    }
}

int solve_for_node(int node,const vector<vector<int>>& graph, const vector<vector<ll>>& weights, const vector<ll>& vehicles)
{
    int n = graph.size();
    priority_queue<pair<ll,int>, vector<pair<ll,int>>, greater<pair<ll,int>>> unexplored_edges;
    ll max_available_vehicle = vehicles[node];
    for(int i = 0; i < graph[node].size();i++)
    {
        unexplored_edges.push({weights[node][i],graph[node][i]});
    }

    vector<bool> node_explored(n);
    node_explored[node] = 1;
    bool explored_something = true;
    while(!unexplored_edges.empty() && explored_something)
    {
        explored_something = false;
        while(!unexplored_edges.empty() && unexplored_edges.top().first <= max_available_vehicle)
        {
            int new_node = unexplored_edges.top().second;
            max_available_vehicle = max(max_available_vehicle,vehicles[new_node]);
            unexplored_edges.pop();

            if(!node_explored[new_node])
            {
                explore_node(new_node,graph,weights,unexplored_edges);
                explored_something = true;
            }
            node_explored[new_node] = 1;
        }
    }
    return count(node_explored.begin(), node_explored.end(),1);
}

// N - broj gradova, A - zastita u gradu i
// M - broj edzova
void Resi(int N, int *A, int M, int *U, int *V, int *W, int *R)
{
    vector<vector<int>> graph(N, vector<int>());
    vector<vector<ll>> weights(N, vector<ll>());
    for(int i = 1; i <= M; i++)
    {
        int a = U[i];
        int b = V[i];
        a--; b--;
        int w = W[i];
        graph[a].push_back(b);
        graph[b].push_back(a);
        weights[a].push_back(w);
        weights[b].push_back(w);
    }

    vector<ll> vehicles(N);
    for(int i = 0; i < N; i++)
    {
        vehicles[i] = A[i+1];
    }
    for(int i = 0; i < N; i++)
    {
        R[i+1] = solve_for_node(i,graph,weights,vehicles);
    }
}

/*int main(){
	int N, M;
	scanf("%i %i", &N, &M);

	int *A = new int[N + 1];
	for(int i = 1; i <= N; i++){
		scanf("%i", &A[i]);
	}

	int *U = new int[M + 1], *V = new int[M + 1], *W = new int[M + 1];
	for(int i = 1; i <= M; i++){
		scanf("%i %i %i", &U[i], &V[i], &W[i]);
	}

	int *R = new int[N + 1];
	Resi(N, A, M, U, V, W, R);

	for(int i = 1; i <= N; i++){
		printf("%i ", R[i]);
	}
	printf("\n");

	delete[] A;
	delete[] U;
	delete[] V;
	delete[] W;
	delete[] R;

	return 0;
}*/