#include <algorithm>
#include <iostream>
#include <queue>
#include <vector>
using namespace std;
typedef long long ll;
template<typename T> void print_vec(const vector<vector<T>>& v)
{
    for (auto row : v)
    {
        for (auto col : row)
            cout << col << " ";
        cout << "\n";
    }
    cout << "\n";
}
template<typename T> void print_vec(const vector<T>& v)
{
    for (auto col : v)
        cout << col << " ";
    cout << "\n";
}

void explore_node(int node, const vector<vector<int>>& graph, const vector<vector<ll>>& weights, priority_queue<pair<ll, int>, vector<pair<ll, int>>, greater<pair<ll, int>>>& unexplored_edges)
{
    for (int i = 0; i < graph[node].size(); i++)
    {
        unexplored_edges.push({ weights[node][i],graph[node][i] });
    }
}

int solve_for_node(int node, const vector<vector<int>>& graph, const vector<vector<ll>>& weights, const vector<ll>& vehicles)
{
    int n = graph.size();
    priority_queue<pair<ll, int>, vector<pair<ll, int>>, greater<pair<ll, int>>> unexplored_edges;
    ll max_available_vehicle = vehicles[node];
    for (int i = 0; i < graph[node].size(); i++)
    {
        unexplored_edges.push({ weights[node][i],graph[node][i] });
    }

    vector<bool> node_explored(n);
    node_explored[node] = 1;
    bool explored_something = true;
    while (!unexplored_edges.empty() && explored_something)
    {
        explored_something = false;
        while (!unexplored_edges.empty() && unexplored_edges.top().first <= max_available_vehicle)
        {
            int new_node = unexplored_edges.top().second;
            max_available_vehicle = max(max_available_vehicle, vehicles[new_node]);
            unexplored_edges.pop();

            if (!node_explored[new_node])
            {
                explore_node(new_node, graph, weights, unexplored_edges);
                explored_something = true;
            }
            node_explored[new_node] = 1;
        }
    }
    return count(node_explored.begin(), node_explored.end(), 1);
}

void dfs(int node, const vector<vector<int>>& graph, const vector<vector<ll>>& weights, vector<int>& component, int current_component, ll vehicle)
{
    component[node] = current_component;
    for (int i = 0; i < graph[node].size(); i++)
    {
int neighbor = graph[node][i];
if (component[neighbor] == -1 && weights[node][i] <= vehicle)
dfs(neighbor, graph, weights, component, current_component, vehicle);
    }
}
void dfs(int node, const vector<vector<int>>& graph, vector<int>& component, int current_component)
{
    component[node] = current_component;
    for (int i = 0; i < graph[node].size(); i++)
    {
        int neighbor = graph[node][i];
        if (component[neighbor] == -1)
            dfs(neighbor, graph, component, current_component);
    }
}

vector<int> first_subtask(const vector<vector<int>>& graph, const vector<vector<ll>>& weights, ll vehicle)
{
    vector<int> component(graph.size(), -1);
    int component_id = 0;
    for (int node = 0; node < graph.size(); node++)
    {
        if (component[node] == -1)
        {
            dfs(node, graph, weights, component, component_id++, vehicle);
        }
    }
    vector<int> component_size(graph.size());
    for (int i : component)
    {
        component_size[i]++;
    }
    vector<int> solution(graph.size());
    for (int i = 0; i < graph.size(); i++)
    {
        solution[i] = component_size[component[i]];
    }
    return solution;
}
vector<int> second_subtask(const vector<vector<int>>& graph, ll weight, const vector<ll>& vehicles)
{
    vector<int> component(graph.size(), -1);
    int component_id = 0;
    for (int node = 0; node < graph.size(); node++)
    {
        if (component[node] == -1)
        {
            dfs(node, graph, component, component_id++);
        }
    }
    vector<int> component_size(graph.size());
    for (int i : component)
    {
        component_size[i]++;
    }
    vector<int> solution(graph.size());

    for (int i = 0; i < graph.size(); i++)
    {
        if (vehicles[i] >= weight)
        {
            solution[i] = component_size[component[i]];
        }
        else
            solution[i] = 1;
    }
    return solution;
}

// N - broj gradova, A - zastita u gradu i
// M - broj edzova
void Resi(int N, int* A, int M, int* U, int* V, int* W, int* R)
{
    vector<vector<int>> graph(N, vector<int>());
    vector<vector<ll>> weights(N, vector<ll>());
    vector<ll> weights_flat;
    for (int i = 1; i <= M; i++)
    {
        int a = U[i];
        int b = V[i];
        a--; b--;
        int w = W[i];
        graph[a].push_back(b);
        graph[b].push_back(a);
        weights[a].push_back(w);
        weights[b].push_back(w);
        weights_flat.push_back(w);
    }
    vector<ll> vehicles(N);
    for (int i = 0; i < N; i++)
    {
        vehicles[i] = A[i + 1];
    }
    if (count(vehicles.begin(), vehicles.end(), vehicles[0]) == vehicles.size())
    {
        auto sol = first_subtask(graph, weights, vehicles[0]);
        for (int i = 0; i < N; i++)
        {
            R[i + 1] = sol[i];
        }
    }
    else if (count(weights_flat.begin(), weights_flat.end(), weights_flat[0]) == weights_flat.size())
    {
        auto sol = second_subtask(graph, weights_flat[0], vehicles);
        for (int i = 0; i < N; i++)
        {
            R[i + 1] = sol[i];
        }
    }
    else
    {
        for (int i = 0; i < N; i++)
        {
            R[i + 1] = solve_for_node(i, graph, weights, vehicles);
        }
    }
 
}