#include <bits/stdc++.h>
#include "code.h"
using namespace std;
typedef long long ll;
template<typename T> void print_vec(const vector<vector<T>>& v)
{
    for(auto row: v)
    {
        for(auto col: row)
            cout << col << " ";
        cout << "\n";
    }
    cout << "\n";
}

template<typename T> void print_vec(const vector<T>& v)
{

    for(auto col: v)
        cout << col << " ";
    cout << "\n";

    cout << "\n";
}

void print_map(const map<int,int> m)
{
    for(auto kvp: m)
    {
        cout << kvp.first << " " << kvp.second << "\n";
    }
    cout << "\n";
}

// Array coded as (+1): the element >= N/2, (-1): it's inverse
// 0 - other
pair<int,int> solve_given_array(const vector<int>& v, int cnt_big_element, int cnt_inverse)
{
    int n = v.size();
    int d = cnt_big_element - n/2;
    vector<int> prefix_sums(n);
    vector<int> prefix_big_element(n);
    vector<int> count_big_element(n), count_inverses(n);
    map<int,int> sum_pos_map_right;
    prefix_sums[0] = v[0];

    //sum_pos_map_right[prefix_sums[0]] = 0;
    count_big_element[0] = (v[0] == 1 ? 1 : 0);
    count_inverses[0] = (v[0] == -1 ? 1 : 0);

    for(int i = 1; i < n; i++)
    {
        count_big_element[i] = (v[i] == 1 ? count_big_element[i-1]+1 : count_big_element[i-1]);
        count_inverses[i] = (v[i] == -1 ? count_inverses[i-1] + 1 : count_inverses[i-1]);

        prefix_sums[i] = prefix_sums[i-1] + v[i];
        sum_pos_map_right[prefix_sums[i]] = i;
    }
    //print_vec(prefix_sums);

    int current_prefix = 0;
    for(int i = 0; i < n; i++)
    {
        //print_map(sum_pos_map_right);
        auto lb = sum_pos_map_right.lower_bound(current_prefix + d);
        if(lb != sum_pos_map_right.end())
        {
            int cnt_el_in_seg = (i == 0 ? count_big_element[lb->second] : count_big_element[lb->second] - count_big_element[i-1]);
            int cnt_inv_in_seg = (i == 0 ? count_inverses[lb->second] : count_inverses[lb->second] - count_inverses[i-1]);

            int new_inv_count = cnt_inverse + cnt_el_in_seg - cnt_inv_in_seg;
            if(new_inv_count <= n/2)
            {
                //cout << lb->second<<"\n";
             return {i,lb->second};

            }
        }
        current_prefix = prefix_sums[i];
        sum_pos_map_right.erase(current_prefix);
    }
    return {-1,-1};
}

vector<int> find_array(int n, char greatest, char inv)
{
    vector<int> values(n);
    for(int i = 0; i < n; i++)
    {
        if(Skener(i+1,i+1,greatest) == 1)
            values[i] = 1;
        else if(Skener(i+1,i+1,inv) == 1)
            values[i] = -1;
        else
            values[i] = 0;
    }
    return values;
}

void Resi(int N, int *L, int *R) {
    vector<int> values(N);
    vector<char> letters = {'A','U','C','G'};
    vector<int> counts(4);
    for(int i = 0; i < 4; i++)
        counts[i] = Skener(1,N,letters[i]);
    //print_vec(counts);

    map<char,char> inv;
    inv['A'] = 'U';
    inv['U'] = 'A';
    inv['C'] = 'G';
    inv['G'] = 'C';

    if(*max_element(counts.begin(),counts.end()) < N/2)
    {
        *L = 1;
        *R = 1;
    }
    else
    {
        int i = max_element(counts.begin(),counts.end()) - counts.begin();
        char max_char = letters[i];
        char inverse_of_max = inv[max_char];
        auto v = find_array(N,max_char,inverse_of_max);
        map<char,int> counts_map;
        for(int i = 0; i < 4; i++)
            counts_map[letters[i]] = counts[i];
        //print_vec(v);
        auto s = solve_given_array(v,counts_map[max_char],counts_map[inv[max_char]]);
        if(s.first == -1)
        {
            *L = s.first;
            *R = s.second;
        }
        else
        {
            *L = s.first+1;
            *R = s.second+1;
        }
    }
}