#include <iostream>
#include <vector>
#include <algorithm>
#define forn(i, n) for (int i = 0; i < n; i++)
using namespace std;
#define pii pair<int, int>
struct pt {
    int x, y;
    pt operator-(pt& other) {
        return {x-other.x, y - other.y};
    }
    pt operator+(pt other) {
        return {x+other.x, y + other.y};
    }
    bool operator<(pt& other) {
        if (x == other.x) return y < other.y;
        return x < other.x;
    }
};
int side(pt a, pt x) {
    if (a.x < 0) {
        a.x *= -1;
        return (-1)*side(a, x);
    }
    if (x.x < 0) {
        x.x *= -1;
        return (-1)*side(a, x);
    }
    int lhs = a.y * x.x, rhs = a.x * x.y;
    if (lhs > rhs) return 1;
    else if (lhs < rhs) return -1;
    else return 0;
}
int side(pt a, pt b, pt x) {
    return side(a-b, x-b);
}

vector<pt> grandmascan(vector<pt> dotz) {
    if (dotz.size() == 1) return dotz;
    sort(dotz.begin(), dotz.end());
    pt a = dotz[0], b = dotz.back();
    vector<pt> up, down;
    forn(i, dotz.size()) {
        if (side(a, b, dotz[i]) <= 0) {
            // push to up
            while (up.size() > 1 && side(up[up.size()-2], up[up.size()-1], dotz[i]) == -1) up.pop_back();
            bool ok = true;
            if (up.size() > 1 && side(up[up.size()-2], up[up.size()-1], dotz[i]) == 0) {
                if (side(a, up[up.size()-1], dotz[i]) == -1) ok = false;
                else up.pop_back();
            }
            if (ok) up.push_back(dotz[i]);
        } else {
            // push to down
            while (down.size() > 1 && side(down[down.size()-2], down[down.size()-1], dotz[i]) == 1) down.pop_back();
            bool ok = true;
            if (down.size() > 1 && side(down[down.size()-2], down[down.size()-1], dotz[i]) == 0) {
                if (side(a, down[down.size()-1], dotz[i]) == 1) ok = false;
                else down.pop_back();
            }
            if (ok) down.push_back(dotz[i]);
        }
    }
    for (auto e: down) up.push_back(e);
    return up;
}

bool inside(pt a, pt b, pt c, pt x) {
    int abside = side(a, b, x);
    return side(b, c, x) == abside && side(a, c, x) == !abside;
}
bool inside(vector<pt> poly, pt x) {
    for (int i = 2; i < poly.size(); i++) if (inside(poly[0], poly[1], poly[i], x)) return true;
    return false;
}
void Resi(int N, int Px, int Py, int *X, int *Y, int Q, int *L, int *R, bool *O) {
    vector<pt> dotz;
    pt P = {Px, Py};
    for (int i = 1; i <= N; i++) dotz.push_back({X[i], Y[i]});
    for (int i = 1; i <= Q; i++) {
        vector<pt> ndotz;
        for (int j = L[i]-1; j <= R[i]-1; j++) ndotz.push_back(dotz[i]);
        ndotz = grandmascan(ndotz);
        O[i] = inside(ndotz, P);
    }
}