using System;

namespace Zadatak_3
{
    class Program
    {
        static double rastojanjeTacaka(long x1, long y1, long x2, long y2)
        {
            return Math.Sqrt(Math.Pow((x1 - x2), 2) + Math.Pow((y1 - y2), 2));
        }

        static bool uspravnaLinija(long x, long y)
        {
            return x == 0 || y == 0;
        }

        static long[,] ucitajMatricu(long n, long m)
        {
            long[,] matrica = new long[n, m];
            for(long i = 0; i < n; i++) {
                string[] redMatrice = Console.ReadLine().Split();
                for(long j = 0; j < m; j++) {
                    matrica[i,j] = long.Parse(redMatrice[j]);
                }
            }
            return matrica;
        }

        static bool paralelne(long xa, long ya, long xb, long yb)
        {
            if(xa != xb || ya != yb) {
                xa = Math.Abs(xa);
                ya = Math.Abs(ya);
                xb = Math.Abs(xb);
                yb = Math.Abs(yb);
            }
            if (uspravnaLinija(xa, ya) && uspravnaLinija(xb, yb)) {
                if ((xa == 0 && xa == xb) || (ya == 0 && ya == yb)) {
                    return true;
                }
                else {
                    return false;
                }
            }
            else if (uspravnaLinija(xa, ya) != uspravnaLinija(xb, yb)) {
                return false;
            }
            else {

                /*if (xa == xb && ya == yb) {
                    xa = x1 - x2;
                    ya = y1 - y2;
                    xb = x3 - x4;
                    yb = y3 - y4;
                }//Za odredjene primere kada je trougao sa katetama xa i ya slican trouglu sa katetama xb i yb ali suprotan*/

                if (Math.Atan2(xa, ya) == Math.Atan2(xb, yb)) {
                    return true;
                }
                else {
                    return false;
                }
            }
        }

        static void Main(string[] args)
        {
            //Korak 1 - ucitavamo kordinate tacaka
            long n = long.Parse(Console.ReadLine());
            long m = 2;
            long[,] kordinate = ucitajMatricu(n, m);

            //Korak 2 - resavamo zadatak tako sto uzimamo 4 tacke i gledamo da li formiraju trapez tako sto poredimo da li su paralelne dve linije i ako jesu onda pitamo da li je jedna paralelna linija polovina druge
            long br = 0;
            for(long i = 2; i < n ; i++) {
                for(int a = 1; a < n - i; a++) {
                    long k = a + i;
                    double AB = rastojanjeTacaka(kordinate[k - 3, 0], kordinate[k - 3, 1], kordinate[k - 2, 0], kordinate[k - 2, 1]);

                    double CD = rastojanjeTacaka(kordinate[k - 1, 0], kordinate[k - 1, 1], kordinate[k, 0], kordinate[k, 1]);

                    double AD = rastojanjeTacaka(kordinate[k - 3, 0], kordinate[k - 3, 1], kordinate[k, 0], kordinate[k, 1]);

                    double BC = rastojanjeTacaka(kordinate[k - 2, 0], kordinate[k - 2, 1], kordinate[k - 1, 0], kordinate[k - 1, 1]);

                    long xAB = kordinate[k - 3, 0] - kordinate[k - 2, 0];
                    long yAB = kordinate[k - 3, 1] - kordinate[k - 2, 1];

                    long xBC = kordinate[k - 2, 0] - kordinate[k - 1, 0];
                    long yBC = kordinate[k - 2, 1] - kordinate[k - 1, 1];

                    long xCD = kordinate[k - 1, 0] - kordinate[k, 0];
                    long yCD = kordinate[k - 1, 1] - kordinate[k, 1];

                    long xAD = kordinate[k - 3, 0] - kordinate[k, 0];
                    long yAD = kordinate[k - 3, 1] - kordinate[k, 1];

                    //1.Pitamo da li su tacke AB||BC i da li je AB = 2BC ili AB = 1/2 BC

                    if (paralelne(xAB, yAB, xBC, yBC) && (AB == 2 * BC || AB == 0.5 * BC)) {
                        br++;
                    }

                    //2.Pitamo da li su tacke AB||CD i da li je AB = 2CD ili AB = 1/2 CD

                    else if (paralelne(xAB, yAB, xCD, yCD) && (AB == 2 * CD || AB == 0.5 * CD)) {
                        br++;
                    }

                    //3.Pitamo da li su tacke AB||AD i da li je AB = 2AD ili AB = 1/2 AD

                    else if (paralelne(xAB, yAB, xAD, yAD) && (AB == 2 * AD || AB == 0.5 * AD)) {
                        br++;
                    }

                    //4.Pitamo da li su tacke BC||CD i da li je BC = 2CD ili AB = 1/2 CD

                    else if (paralelne(xBC, yBC, xCD, yCD) && (BC == 2 * CD || BC == 0.5 * CD)) {
                        br++;
                    }

                    //5.Pitamo da li su tacke BC||AD i da li je BC = 2AD ili AB = 1/2 AD

                    else if (paralelne(xBC, yBC, xAD, yAD) && (BC == 2 * AD || BC == 0.5 * AD)) {
                        br++;
                    }

                    //6.Pitamo da li su tacke CD||AD i da li je CD = 2AD ili CD = 1/2 AD

                    else if (paralelne(xCD, yCD, xAD, yAD) && (CD == 2 * AD || CD == 0.5 * AD)) {
                        br++;
                    }
                }
            }

            //Korak 3 - ispisujemo brojac

            Console.WriteLine(br);
        }
    }
}