#include <iostream>
#include <vector>
#include <math.h>
using namespace std;
class Tacka {
    public:
        int x;
        int y;
};
class Vector2 {
    public: 
        float x;
        float y;
        void normalizuj() {
            float d = duzina();
            x/=d;
            y/=d;
        }
        float duzina() {
            return sqrt(x*x+y*y);
        }
};
bool isti_vectori(Vector2* prvi, Vector2* drugi) {
    if(prvi->x != drugi->x) return false;
    if(prvi->y != drugi->y) return false;
    return true;
}
Vector2* izracunaj_dir(Tacka* a, Tacka* b) {
    Vector2* dir = new Vector2();
    dir->x = a->x-b->x;
    dir->y = a->y-b->y;
    dir->normalizuj();
    return dir;
}
Vector2* izracunaj_dir(int ax, int ay, int bx, int by) {
    Vector2* dir = new Vector2();
    dir->x = ax-bx;
    dir->y = ay-by;
    dir->normalizuj();
    return dir;
}
bool osnova_duplo_veca(int ax, int ay, int bx, int by, int cx, int cy, int dx, int dy) {
    int dax = abs(ax-bx);
    int day = abs(ay-by);
    int dbx = abs(cx-dx);
    int dby = abs(cy-dy);
    return dax == dbx/2 || dax/2 == dbx || day == dby/2 || day/2 == dby; 
}
bool da_li_je_cetvorka(vector<Tacka*> takmicari, int a,int b,int c,int d) {
    Vector2* dir;
    int ax = takmicari[a]->x;
    int ay = takmicari[a]->y;
    int bx = takmicari[b]->x;
    int by = takmicari[b]->y;
    int cx = takmicari[c]->x;
    int cy = takmicari[c]->y;
    int dx = takmicari[d]->x;
    int dy = takmicari[d]->y;
    if(isti_vectori(izracunaj_dir(ax,ay,bx,by),izracunaj_dir(cx,cy,dx,dy)) && osnova_duplo_veca(ax,ay,bx,by,cx,cy,dx,dy)) return true;
    if(isti_vectori(izracunaj_dir(ax,ay,bx,by),izracunaj_dir(bx,by,cx,cy)) && osnova_duplo_veca(ax,ay,bx,by,bx,by,cx,cy)) return true;
    if(isti_vectori(izracunaj_dir(ax,ay,bx,by),izracunaj_dir(ax,ay,dx,dy)) && osnova_duplo_veca(ax,ay,bx,by,ax,ay,dx,dy)) return true;
    if(isti_vectori(izracunaj_dir(bx,by,cx,cy),izracunaj_dir(cx,cy,dx,dy)) && osnova_duplo_veca(bx,by,cx,cy,cx,cy,dx,dy)) return true;
    if(isti_vectori(izracunaj_dir(bx,by,cx,cy),izracunaj_dir(ax,ay,dx,dy)) && osnova_duplo_veca(bx,by,cx,cy,ax,ay,dx,dy)) return true;
    if(isti_vectori(izracunaj_dir(cx,cy,dx,dy),izracunaj_dir(ax,ay,dx,dy)) && osnova_duplo_veca(cx,cy,dx,dy,ax,ay,dx,dy)) return true;
    if(isti_vectori(izracunaj_dir(ax,ay,bx,by),izracunaj_dir(dx,dy,cx,cy)) && osnova_duplo_veca(ax,ay,bx,by,dx,dy,cx,cy)) return true;
    if(isti_vectori(izracunaj_dir(ax,ay,bx,by),izracunaj_dir(cx,cy,bx,by)) && osnova_duplo_veca(ax,ay,bx,by,cx,cy,bx,by)) return true;
    if(isti_vectori(izracunaj_dir(ax,ay,bx,by),izracunaj_dir(dx,dy,ax,ay)) && osnova_duplo_veca(ax,ay,bx,by,dx,dy,ax,ay)) return true;
    if(isti_vectori(izracunaj_dir(bx,by,cx,cy),izracunaj_dir(dx,dy,cx,cy)) && osnova_duplo_veca(bx,by,cx,cy,dx,dy,cx,cy)) return true;
    if(isti_vectori(izracunaj_dir(bx,by,cx,cy),izracunaj_dir(dx,dy,ax,ay)) && osnova_duplo_veca(bx,by,cx,cy,dx,dy,ax,ay)) return true;
    if(isti_vectori(izracunaj_dir(cx,cy,dx,dy),izracunaj_dir(dx,dy,ax,ay)) && osnova_duplo_veca(cx,cy,dx,dy,dx,dy,ax,ay)) return true;
    return false;
}

int main() {
    int n;
    cin>>n;
    vector<Tacka*> takmicari;
    for(int i = 0; i < n; i++) {
        Tacka* takmicar = new Tacka();
        cin>>takmicar->x>>takmicar->y;
        takmicari.push_back(takmicar);
    }
    int broj = 0;
    if(n>3) 
        for(int i = 0; i < takmicari.size()-3;i++) {
            for(int j = i+1; j < takmicari.size()-2; j++) {
                for(int k = j+1; k < takmicari.size()-1; k++)
                    for(int l = k+1; l < takmicari.size(); l++)
                        if(da_li_je_cetvorka(takmicari,i,j,k,l)) {
                            broj++;
                        }
            }
            free(takmicari[i]);
        }
    cout<<broj<<endl;
}