#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <vector>
#include <algorithm>

struct student
{
	int id;
	int x;
	int y;
};
float find_k(student a, student b)
{
	return ((float)b.y - (float)a.y) / ((float)b.x - (float)a.x);
}
bool compare_ks(float x, float y)
{
	if(std::isinf(x) && std::isinf(y)) return true;
	return x == y;
}
float dist(float x1, float y1, float x2, float y2)
{
    return ((x2 - x1)*(x2 - x1) + (y2 - y1)*(y2 - y1));
}
bool is_trapezoid(student a, student b, student c, student d)
{
	if(compare_ks(find_k(a, b) ,find_k(c, d)))
	{
		float distance = dist(a.x, a.y, b.x, b.y) / dist(c.x, c.y, d.x, d.y);
		if(distance == 4.0f || distance == 0.25f)
		{
			return true;
		}
	}
	else if(compare_ks(find_k(a, c), find_k(b, d)))
	{
		float distance = dist(a.x, a.y, c.x, c.y) / dist(b.x, b.y, d.x, d.y);
		if(distance == 4.0f || distance == 0.25f)
		{
			return true;
		}
	}
	else if(compare_ks(find_k(a, d), find_k(b, c)))
	{
		float distance = dist(a.x, a.y, d.x, d.y) / dist(b.x, b.y, c.x, c.y);
		if(distance == 4.0f || distance == 0.25f)
		{
			return true;
		}
	}
	return false;
}
int main()
{
	int n;
	scanf("%d", &n);
	if(n < 1 || n > 1500) return 1;
	std::vector<student> studenti;
	for(int i = 0; i < n; i++)
	{
		int x;
		int y;
		if(i == n-1)
		{
			scanf("%d %d", &x, &y);
		}
		else
		{
			scanf("%d %d ", &x, &y);
		}
		student s;
		s.id = i;
		s.x = x;
		s.y = y;
		studenti.push_back(s);
	}
	int results = 0;

	for(int i = 0; i < n; i++)
	{
		for(int j = i+1; j < n; j++)
		{
			for(int k = j+1; k < n; k++)
			{
				for(int l = k+1; l < n; l++)
				{
					if(is_trapezoid(studenti[i], studenti[j], studenti[k], studenti[l]))
					{
						results++;
					}
				}
			}
		}
	}
	printf("%d\n", results);
	return 0;
}