#include <bits/stdc++.h>

struct Tacka {
	float x, y;
};

struct Duz {
	Tacka a, b;
	
	Duz() = default;
};

auto nadji_k(const Tacka& a, const Tacka& b) -> float {
	if (a.x == b.x) {
		return INFINITY;
	}
	return (b.y - a.y) / (b.x - a.x);
}

auto main() -> int {
	size_t n;
	std::cin >> n;

	std::vector<Tacka> koordinate;

	for (size_t i = 0; i < n; ++i) {
		int x, y;
		std::cin >> x >> y;

		koordinate.push_back(Tacka { static_cast<float>(x), static_cast<float>(y) });
	}

	std::unordered_map<float, std::vector<Duz>> paralelne_prave;

	for (size_t i = 0; i < n - 1; ++i) {
		for (size_t j = i + 1; j < n; ++j) {
			const auto& a = koordinate[i];
			const auto& b = koordinate[j];
			
			const auto k = nadji_k(a, b);

			try {
				auto& duzi = paralelne_prave.at(k);
				duzi.push_back(Duz{ a, b });
			} catch (std::out_of_range e) {
				paralelne_prave.insert(std::pair<float, std::vector<Duz>>{ k, std::vector<Duz>{ Duz{ a, b } } });
			}
		}
	}

	size_t trapezi = 0;

	for (const auto& kv : paralelne_prave) {
		const auto& duzi = kv.second;

		if (!duzi.size()) {
			continue;
		}

		std::vector<float> duzine;
		std::transform(begin(duzi), end(duzi), std::back_inserter(duzine), [](const Duz& duz) {
			return std::sqrt(std::pow(duz.a.x - duz.b.x, 2.f) + std::pow(duz.a.y - duz.b.y, 2.f));
		});

		for (auto duzina = begin(duzine); duzina != end(duzine); ++duzina) {
			if (std::find_if(duzina, end(duzine), [&duzina](const float d) {
				return d == *duzina / 2.f || d == *duzina * 2.f;
				}) != end(duzine)) {
				++trapezi;
			}
		}

	}

	std::cout << trapezi << '\n';
}